/**
 * Copyright (C) 2014-2015 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.bootstrap3;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.helger.commons.annotations.Nonempty;
import com.helger.html.resource.js.ConstantJSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;

public enum EBootstrapJSPathProvider implements IJSPathProvider
{
  BOOTSTRAP_334 ("bootstrap/3.3.4/js/bootstrap.js"),
  BOOTSTRAP_DATATABLES ("bootstrap/datatables/bootstrap3-datatables.js"),
  BOOTSTRAP_PH ("bootstrap/bootstrap3-ph.js"),
  DATETIMEPICKER ("bootstrap/datetimepicker/bootstrap-datetimepicker.js"),
  DATETIMEPICKER_LOCALE ("bootstrap/datetimepicker/locales/bootstrap-datetimepicker.{0}.js", null, false),
  TREE_VIEW ("bootstrap/treeview/bootstrap-treeview.js");

  private final ConstantJSPathProvider m_aPP;

  private EBootstrapJSPathProvider (@Nonnull @Nonempty final String sPath)
  {
    m_aPP = new ConstantJSPathProvider (sPath);
  }

  private EBootstrapJSPathProvider (@Nonnull @Nonempty final String sPath,
                                    @Nullable final String sConditionalComment,
                                    final boolean bCanBeBundled)
  {
    m_aPP = new ConstantJSPathProvider (sPath, sConditionalComment, bCanBeBundled);
  }

  @Nonnull
  @Nonempty
  public String getJSItemPath (final boolean bRegular)
  {
    return m_aPP.getJSItemPath (bRegular);
  }

  @Nullable
  public String getConditionalComment ()
  {
    return m_aPP.getConditionalComment ();
  }

  public boolean canBeBundled ()
  {
    return m_aPP.canBeBundled ();
  }

  @Nonnull
  public IJSPathProvider getInstance (@Nonnull @Nonempty final String sLanguage)
  {
    return new ConstantJSPathProvider (m_aPP.getJSItemPathRegular ().replace ("{0}", sLanguage),
                                       m_aPP.getConditionalComment (),
                                       true);
  }
}
