/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections;

import com.helger.commons.IHasSize;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.annotations.UseDirectEqualsAndHashCode;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@UseDirectEqualsAndHashCode
@NotThreadSafe
public class LRUCache<KEYTYPE, VALUETYPE>
extends LinkedHashMap<KEYTYPE, VALUETYPE>
implements IHasSize {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final int m_nMaxSize;

    public LRUCache(@Nonnegative int n) {
        super(n, 0.75f, true);
        this.m_nMaxSize = n;
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    @OverrideOnDemand
    protected void onRemoveEldestEntry(@Nonnull Map.Entry<KEYTYPE, VALUETYPE> entry) {
    }

    @Override
    protected final boolean removeEldestEntry(@Nonnull Map.Entry<KEYTYPE, VALUETYPE> entry) {
        if (this.size() <= this.m_nMaxSize) {
            return false;
        }
        this.onRemoveEldestEntry(entry);
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LRUCache lRUCache = (LRUCache)object;
        return EqualsUtils.equals(this.m_nMaxSize, lRUCache.m_nMaxSize) && this.entrySet().equals(lRUCache.entrySet());
    }

    @Override
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this).append(this.m_nMaxSize);
        for (Map.Entry entry : this.entrySet()) {
            hashCodeGenerator.append(entry.getKey()).append(entry.getValue());
        }
        return hashCodeGenerator.getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("maxSize", this.m_nMaxSize).append("map", super.toString()).toString();
    }
}

