/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ArrayIteratorInt {
    private final int[] m_aArray;
    private int m_nIndex;

    public ArrayIteratorInt(int ... nArray) {
        ValueEnforcer.notNull(nArray, "Array");
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy(nArray);
    }

    private ArrayIteratorInt(@Nonnull int[] nArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(nArray, n, n2);
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy(nArray, n, n2);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    public int next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    @Deprecated
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayIteratorInt)) {
            return false;
        }
        ArrayIteratorInt arrayIteratorInt = (ArrayIteratorInt)object;
        return EqualsUtils.equals(this.m_aArray, arrayIteratorInt.m_aArray) && this.m_nIndex == arrayIteratorInt.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).toString();
    }

    @Nonnull
    public static ArrayIteratorInt createOfsLen(@Nonnull int[] nArray, @Nonnegative int n, @Nonnegative int n2) {
        return new ArrayIteratorInt(nArray, n, n2);
    }

    @Nonnull
    public static ArrayIteratorInt createBeginEnd(@Nonnull int[] nArray, @Nonnegative int n, @Nonnegative int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Begin (" + n + ") must be between 0 and < end (" + n2 + ")");
        }
        return ArrayIteratorInt.createOfsLen(nArray, n, n2 - n);
    }
}

