/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.filter.IFilter;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FilterInverted<DATATYPE>
implements IFilter<DATATYPE> {
    private final IFilter<DATATYPE> m_aOriginalFilter;

    public FilterInverted(@Nonnull IFilter<DATATYPE> iFilter) {
        this.m_aOriginalFilter = ValueEnforcer.notNull(iFilter, "OriginalFilter");
    }

    @Nonnull
    public IFilter<DATATYPE> getOriginalFilter() {
        return this.m_aOriginalFilter;
    }

    @Override
    public boolean matchesFilter(DATATYPE DATATYPE) {
        return !this.m_aOriginalFilter.matchesFilter(DATATYPE);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilterInverted)) {
            return false;
        }
        FilterInverted filterInverted = (FilterInverted)object;
        return this.m_aOriginalFilter.equals(filterInverted.m_aOriginalFilter);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aOriginalFilter).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("originalFilter", this.m_aOriginalFilter).toString();
    }
}

