/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.filter.ISerializableFilter;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SerializableFilterInverted<DATATYPE>
implements ISerializableFilter<DATATYPE> {
    private final ISerializableFilter<DATATYPE> m_aOriginalFilter;

    public SerializableFilterInverted(@Nonnull ISerializableFilter<DATATYPE> iSerializableFilter) {
        this.m_aOriginalFilter = ValueEnforcer.notNull(iSerializableFilter, "OriginalFilter");
    }

    @Nonnull
    public ISerializableFilter<DATATYPE> getOriginalFilter() {
        return this.m_aOriginalFilter;
    }

    @Override
    public boolean matchesFilter(DATATYPE DATATYPE) {
        return !this.m_aOriginalFilter.matchesFilter(DATATYPE);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SerializableFilterInverted)) {
            return false;
        }
        SerializableFilterInverted serializableFilterInverted = (SerializableFilterInverted)object;
        return this.m_aOriginalFilter.equals(serializableFilterInverted.m_aOriginalFilter);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aOriginalFilter).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("originalFilter", this.m_aOriginalFilter).toString();
    }
}

