/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.hash;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.UseDirectEqualsAndHashCode;
import com.helger.commons.cache.AnnotationUsageCache;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.hash.IHashCodeImplementation;
import com.helger.commons.hash.IHashCodeImplementationRegistrarSPI;
import com.helger.commons.hash.IHashCodeImplementationRegistry;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.ServiceLoaderUtils;
import com.helger.commons.state.EChange;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class HashCodeImplementationRegistry
implements IHashCodeImplementationRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(HashCodeImplementationRegistry.class);
    private static final HashCodeImplementationRegistry s_aInstance = new HashCodeImplementationRegistry();
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final Map<Class<?>, IHashCodeImplementation> m_aMap = new WeakHashMap();
    private final AnnotationUsageCache m_aDirectHashCode = new AnnotationUsageCache(UseDirectEqualsAndHashCode.class);
    private final Map<String, Boolean> m_aImplementsHashCode = new HashMap<String, Boolean>();

    private HashCodeImplementationRegistry() {
        for (IHashCodeImplementationRegistrarSPI iHashCodeImplementationRegistrarSPI : ServiceLoaderUtils.getAllSPIImplementations(IHashCodeImplementationRegistrarSPI.class)) {
            iHashCodeImplementationRegistrarSPI.registerHashCodeImplementations(this);
        }
    }

    @Nonnull
    public static HashCodeImplementationRegistry getInstance() {
        return s_aInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerHashCodeImplementation(@Nonnull Class<?> clazz, @Nonnull IHashCodeImplementation iHashCodeImplementation) {
        ValueEnforcer.notNull(clazz, "Class");
        ValueEnforcer.notNull(iHashCodeImplementation, "Implementation");
        if (clazz.equals(Object.class)) {
            throw new IllegalArgumentException("You cannot provide a hashCode implementation for Object.class!");
        }
        this.m_aRWLock.writeLock().lock();
        try {
            IHashCodeImplementation iHashCodeImplementation2 = this.m_aMap.get(clazz);
            if (iHashCodeImplementation2 == null) {
                this.m_aMap.put(clazz, iHashCodeImplementation);
            } else if (iHashCodeImplementation2 != iHashCodeImplementation) {
                s_aLogger.warn("Another hashCode implementation for class " + clazz + " is already registered (" + iHashCodeImplementation2.toString() + ") so it is not overwritten with " + iHashCodeImplementation.toString());
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    public EChange unregisterHashCodeImplementation(@Nonnull Class<?> clazz) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(this.m_aMap.remove(clazz) != null);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    private boolean _isUseDirectHashCode(@Nonnull Class<?> clazz) {
        return this.m_aDirectHashCode.hasAnnotation(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _implementsHashCodeItself(@Nonnull Class<?> clazz) {
        Boolean bl;
        block11: {
            String string = clazz.getName();
            this.m_aRWLock.readLock().lock();
            try {
                bl = this.m_aImplementsHashCode.get(string);
            }
            finally {
                this.m_aRWLock.readLock().unlock();
            }
            if (bl == null) {
                this.m_aRWLock.writeLock().lock();
                try {
                    bl = this.m_aImplementsHashCode.get(string);
                    if (bl != null) break block11;
                    boolean bl2 = false;
                    try {
                        Method method = clazz.getDeclaredMethod("hashCode", new Class[0]);
                        if (method != null && method.getReturnType().equals(Integer.TYPE)) {
                            bl2 = true;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    bl = bl2;
                    this.m_aImplementsHashCode.put(string, bl);
                }
                finally {
                    this.m_aRWLock.writeLock().unlock();
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IHashCodeImplementation getBestMatchingHashCodeImplementation(@Nullable Class<?> clazz) {
        if (clazz != null) {
            Class clazz2;
            IHashCodeImplementation iHashCodeImplementation;
            block13: {
                iHashCodeImplementation = null;
                clazz2 = null;
                if (this._isUseDirectHashCode(clazz)) {
                    return null;
                }
                this.m_aRWLock.readLock().lock();
                try {
                    iHashCodeImplementation = this.m_aMap.get(clazz);
                    if (iHashCodeImplementation != null) {
                        clazz2 = clazz;
                        break block13;
                    }
                    for (WeakReference<Class<?>> weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                        IHashCodeImplementation iHashCodeImplementation2;
                        Class clazz3 = (Class)weakReference.get();
                        if (clazz3 == null || (iHashCodeImplementation2 = this.m_aMap.get(clazz3)) == null) continue;
                        iHashCodeImplementation = iHashCodeImplementation2;
                        clazz2 = clazz3;
                        if (s_aLogger.isDebugEnabled()) {
                            s_aLogger.debug("Found hierarchical match with class " + clazz2 + " when searching for " + clazz);
                        }
                        break;
                    }
                }
                finally {
                    this.m_aRWLock.readLock().unlock();
                }
            }
            if (iHashCodeImplementation != null) {
                if (ClassHelper.isInterface(clazz2) && this._implementsHashCodeItself(clazz)) {
                    this.m_aDirectHashCode.setAnnotation(clazz, true);
                    return null;
                }
                if (!clazz2.equals(clazz)) {
                    this.registerHashCodeImplementation(clazz, iHashCodeImplementation);
                }
                return iHashCodeImplementation;
            }
            if (ClassHelper.isArrayClass(clazz)) {
                return new ArrayHashCodeImplementation();
            }
            this.m_aDirectHashCode.setAnnotation(clazz, true);
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Found no hashCode implementation for " + clazz);
        }
        return null;
    }

    public static int getHashCode(@Nullable Object object) {
        if (object == null) {
            return 129;
        }
        Class<?> clazz = object.getClass();
        IHashCodeImplementation iHashCodeImplementation = s_aInstance.getBestMatchingHashCodeImplementation(clazz);
        return iHashCodeImplementation == null ? object.hashCode() : iHashCodeImplementation.getHashCode(object);
    }

    public static void clearCache() {
        HashCodeImplementationRegistry.s_aInstance.m_aDirectHashCode.clearCache();
    }

    private static final class ArrayHashCodeImplementation
    implements IHashCodeImplementation {
        @Override
        public int getHashCode(Object object) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object).append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(objectArray[i]);
            }
            return hashCodeGenerator.getHashCode();
        }
    }
}

