/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.i18n;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.i18n.AbstractCodepointIterator;
import com.helger.commons.i18n.Codepoint;
import com.helger.commons.i18n.CodepointIteratorCharArray;
import com.helger.commons.i18n.CodepointIteratorCharSequence;
import com.helger.commons.i18n.CodepointIteratorRestricted;
import com.helger.commons.i18n.ECodepointProfile;
import com.helger.commons.i18n.ICodepointFilter;
import com.helger.commons.i18n.ICodepointIterator;
import com.helger.commons.regex.RegExHelper;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CodepointUtils {
    private static final CodepointUtils s_aInstance = new CodepointUtils();
    public static final char LRE = '\u202a';
    public static final char RLE = '\u202b';
    public static final char LRO = '\u202d';
    public static final char RLO = '\u202e';
    public static final char LRM = '\u200e';
    public static final char RLM = '\u200f';
    public static final char PDF = '\u202c';

    private CodepointUtils() {
    }

    public static boolean inRange(char[] cArray, char c, char c2) {
        for (char c3 : cArray) {
            if (c3 >= c && c3 <= c2) continue;
            return false;
        }
        return true;
    }

    public static boolean inRange(char[] cArray, int n, int n2) {
        for (int i = 0; i < cArray.length; ++i) {
            int n3;
            int n4 = cArray[i];
            int n5 = n3 = Character.isHighSurrogate((char)n4) && i + 1 < cArray.length && Character.isLowSurrogate(cArray[i + 1]) ? Character.toCodePoint((char)n4, cArray[i++]) : n4;
            if (n3 >= n && n3 <= n2) continue;
            return false;
        }
        return true;
    }

    public static boolean inRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public static char getHighSurrogate(int n) {
        return Character.isSupplementaryCodePoint(n) ? (char)(55232 + (n >> 10)) : (char)'\u0000';
    }

    public static char getLowSurrogate(int n) {
        return Character.isSupplementaryCodePoint(n) ? (char)(56320 + (n & 0x3FF)) : (char)n;
    }

    @Nonnull
    public static Codepoint codepointAt(@Nonnull CharSequence charSequence, int n) {
        char c;
        char c2 = charSequence.charAt(n);
        if (c2 < '\ud800' || c2 > '\udfff') {
            return new Codepoint(c2);
        }
        if (Character.isHighSurrogate(c2)) {
            char c3;
            if (charSequence.length() != n && Character.isLowSurrogate(c3 = charSequence.charAt(n + 1))) {
                return new Codepoint(c2, c3);
            }
        } else if (Character.isLowSurrogate(c2) && n >= 1 && Character.isHighSurrogate(c = charSequence.charAt(n - 1))) {
            return new Codepoint(c, c2);
        }
        return new Codepoint(c2);
    }

    public static void insert(CharSequence charSequence, int n, @Nonnull Codepoint codepoint) {
        CodepointUtils.insert(charSequence, n, codepoint.getValue());
    }

    public static void insert(@Nonnull CharSequence charSequence, int n, int n2) {
        if (!(charSequence instanceof StringBuilder) && !(charSequence instanceof StringBuffer)) {
            CodepointUtils.insert((CharSequence)new StringBuilder(charSequence), n, n2);
        } else {
            char c;
            boolean bl;
            int n3 = n;
            if (n3 > 0 && n3 < charSequence.length() && (bl = Character.isLowSurrogate(c = charSequence.charAt(n3))) && Character.isHighSurrogate(charSequence.charAt(n3 - 1))) {
                --n3;
            }
            if (charSequence instanceof StringBuffer) {
                ((StringBuffer)charSequence).insert(n3, CodepointUtils.getAsCharArray(n2));
            } else {
                ((StringBuilder)charSequence).insert(n3, CodepointUtils.getAsCharArray(n2));
            }
        }
    }

    public static void setChar(@Nonnull CharSequence charSequence, int n, @Nonnull Codepoint codepoint) {
        CodepointUtils.setChar(charSequence, n, codepoint.getValue());
    }

    public static void setChar(@Nonnull CharSequence charSequence, int n, int n2) {
        if (!(charSequence instanceof StringBuilder) && !(charSequence instanceof StringBuffer)) {
            CodepointUtils.setChar((CharSequence)new StringBuilder(charSequence), n, n2);
        } else {
            int n3 = 1;
            int n4 = n;
            char c = charSequence.charAt(n4);
            boolean bl = Character.isHighSurrogate(c);
            boolean bl2 = Character.isLowSurrogate(c);
            if (bl || bl2) {
                if (bl && n4 + 1 < charSequence.length() && Character.isLowSurrogate(charSequence.charAt(n4 + 1))) {
                    ++n3;
                } else if (bl2 && n4 > 0 && Character.isHighSurrogate(charSequence.charAt(n4 - 1))) {
                    --n4;
                    ++n3;
                }
            }
            if (charSequence instanceof StringBuffer) {
                ((StringBuffer)charSequence).replace(n4, n4 + n3, CodepointUtils.getAsString(n2));
            } else {
                ((StringBuilder)charSequence).replace(n4, n4 + n3, CodepointUtils.getAsString(n2));
            }
        }
    }

    public static int length(@Nonnull CharSequence charSequence) {
        return CodepointUtils.length(new CodepointIteratorCharSequence(charSequence));
    }

    public static int length(@Nonnull char[] cArray) {
        return CodepointUtils.length(new CodepointIteratorCharArray(cArray));
    }

    public static int length(@Nonnull AbstractCodepointIterator abstractCodepointIterator) {
        int n = 0;
        while (abstractCodepointIterator.hasNext()) {
            abstractCodepointIterator.next();
            ++n;
        }
        return n;
    }

    @Nonnull
    @Nonempty
    public static char[] getAsCharArray(int n) {
        return Character.toChars(n);
    }

    @Nonnull
    @Nonempty
    public static String getAsString(int n) {
        return new String(CodepointUtils.getAsCharArray(n));
    }

    @Nullable
    public static String stripBidi(@Nullable String string) {
        if (string == null || string.length() <= 1) {
            return string;
        }
        String string2 = string;
        if (CodepointUtils.isBidi(string2.charAt(0))) {
            string2 = string2.substring(1);
        }
        if (CodepointUtils.isBidi(string2.charAt(string2.length() - 1))) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Nonnull
    public static String stripBidiInternal(@Nonnull String string) {
        return RegExHelper.stringReplacePattern("[\u202a\u202b\u202d\u202e\u200e\u200f\u202c]", string, "");
    }

    @Nonnull
    private static String _wrap(String string, char c, char c2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (stringBuilder.length() > 1) {
            if (stringBuilder.charAt(0) != c) {
                stringBuilder.insert(0, c);
            }
            if (stringBuilder.charAt(stringBuilder.length() - 1) != c2) {
                stringBuilder.append(c2);
            }
        }
        return stringBuilder.toString();
    }

    public static String wrapBidi(@Nonnull String string, char c) {
        switch (c) {
            case '\u202b': {
                return CodepointUtils._wrap(string, '\u202b', '\u202c');
            }
            case '\u202e': {
                return CodepointUtils._wrap(string, '\u202e', '\u202c');
            }
            case '\u202a': {
                return CodepointUtils._wrap(string, '\u202a', '\u202c');
            }
            case '\u202d': {
                return CodepointUtils._wrap(string, '\u202d', '\u202c');
            }
            case '\u200f': {
                return CodepointUtils._wrap(string, '\u200f', '\u200f');
            }
            case '\u200e': {
                return CodepointUtils._wrap(string, '\u200e', '\u200e');
            }
        }
        return string;
    }

    public static boolean isDigit(@Nonnull Codepoint codepoint) {
        return CodepointUtils.isDigit(codepoint.getValue());
    }

    public static boolean isDigit(int n) {
        return Character.isDigit(n);
    }

    public static boolean isAlpha(@Nonnull Codepoint codepoint) {
        return CodepointUtils.isAlpha(codepoint.getValue());
    }

    public static boolean isAlpha(int n) {
        return Character.isLetter(n);
    }

    public static boolean isAlphaDigit(@Nonnull Codepoint codepoint) {
        return CodepointUtils.isAlphaDigit(codepoint.getValue());
    }

    public static boolean isAlphaDigit(int n) {
        return Character.isLetterOrDigit(n);
    }

    public static boolean isHex(int n) {
        return CodepointUtils.isDigit(n) || CodepointUtils.inRange(n, 97, 102) || CodepointUtils.inRange(n, 65, 70);
    }

    public static boolean isBidi(@Nonnull Codepoint codepoint) {
        return CodepointUtils.isBidi(codepoint.getValue());
    }

    public static boolean isBidi(int n) {
        return n == 8206 || n == 8207 || n == 8234 || n == 8235 || n == 8237 || n == 8238 || n == 8236;
    }

    @CheckForSigned
    public static int getIndex(@Nonnull int[] nArray, int n) {
        int n2 = 0;
        int n3 = nArray.length;
        while (n3 - n2 > 8) {
            int n4 = n3 + n2 >>> 1;
            n2 = nArray[n4] <= n ? n4 : n2;
            n3 = nArray[n4] > n ? n4 : n3;
        }
        while (n2 < n3 && n >= nArray[n2]) {
            ++n2;
        }
        return n2 == n3 ? -1 : n2 - 1;
    }

    public static boolean inverseSetContains(@Nonnull int[] nArray, int n) {
        int n2 = 0;
        int n3 = nArray.length;
        while (n3 - n2 > 8) {
            int n4 = n3 + n2 >>> 1;
            n2 = nArray[n4] <= n ? n4 : n2;
            n3 = nArray[n4] > n ? n4 : n3;
        }
        while (n2 < n3 && n >= nArray[n2]) {
            ++n2;
        }
        return (n2 - 1 & 1) == 0;
    }

    public static boolean isPctEnc(int n) {
        return n == 37 || CodepointUtils.isDigit(n) || CodepointUtils.inRange(n, 65, 70) || CodepointUtils.inRange(n, 97, 102);
    }

    public static boolean isMark(int n) {
        return n == 45 || n == 95 || n == 46 || n == 33 || n == 126 || n == 42 || n == 92 || n == 39 || n == 40 || n == 41;
    }

    public static boolean isUnreserved(int n) {
        return CodepointUtils.isAlphaDigit(n) || n == 45 || n == 46 || n == 95 || n == 126;
    }

    public static boolean isReserved(int n) {
        return n == 36 || n == 38 || n == 43 || n == 44 || n == 47 || n == 58 || n == 59 || n == 61 || n == 63 || n == 64 || n == 91 || n == 93;
    }

    public static boolean isGenDelim(int n) {
        return n == 35 || n == 47 || n == 58 || n == 63 || n == 64 || n == 91 || n == 93;
    }

    public static boolean isSubDelim(int n) {
        return n == 33 || n == 36 || n == 38 || n == 39 || n == 40 || n == 41 || n == 42 || n == 43 || n == 44 || n == 59 || n == 61 || n == 92;
    }

    public static boolean isPchar(int n) {
        return CodepointUtils.isUnreserved(n) || n == 58 || n == 64 || n == 38 || n == 61 || n == 43 || n == 36 || n == 44;
    }

    public static boolean isPath(int n) {
        return CodepointUtils.isPchar(n) || n == 59 || n == 47 || n == 37 || n == 44;
    }

    public static boolean isPathNoDelims(int n) {
        return CodepointUtils.isPath(n) && !CodepointUtils.isGenDelim(n);
    }

    public static boolean isScheme(int n) {
        return CodepointUtils.isAlphaDigit(n) || n == 43 || n == 45 || n == 46;
    }

    public static boolean isUserInfo(int n) {
        return CodepointUtils.isUnreserved(n) || CodepointUtils.isSubDelim(n) || CodepointUtils.isPctEnc(n);
    }

    public static boolean isQuery(int n) {
        return CodepointUtils.isPchar(n) || n == 59 || n == 47 || n == 63 || n == 37;
    }

    public static boolean isFragment(int n) {
        return CodepointUtils.isPchar(n) || n == 47 || n == 63 || n == 37;
    }

    public static boolean is_ucschar(int n) {
        return CodepointUtils.inRange(n, 160, 55295) || CodepointUtils.inRange(n, 63744, 64975) || CodepointUtils.inRange(n, 65008, 65519) || CodepointUtils.inRange(n, 65536, 131069) || CodepointUtils.inRange(n, 131072, 196605) || CodepointUtils.inRange(n, 196608, 262141) || CodepointUtils.inRange(n, 262144, 327677) || CodepointUtils.inRange(n, 327680, 393213) || CodepointUtils.inRange(n, 393216, 458749) || CodepointUtils.inRange(n, 458752, 524285) || CodepointUtils.inRange(n, 524288, 589821) || CodepointUtils.inRange(n, 589824, 655357) || CodepointUtils.inRange(n, 655360, 720893) || CodepointUtils.inRange(n, 720896, 786429) || CodepointUtils.inRange(n, 786432, 851965) || CodepointUtils.inRange(n, 851968, 917501) || CodepointUtils.inRange(n, 921600, 983037);
    }

    public static boolean is_iprivate(int n) {
        return CodepointUtils.inRange(n, 57344, 63743) || CodepointUtils.inRange(n, 983040, 1048573) || CodepointUtils.inRange(n, 0x100000, 1114109);
    }

    public static boolean is_iunreserved(int n) {
        return CodepointUtils.isAlphaDigit(n) || CodepointUtils.isMark(n) || CodepointUtils.is_ucschar(n);
    }

    public static boolean is_ipchar(int n) {
        return CodepointUtils.is_iunreserved(n) || CodepointUtils.isSubDelim(n) || n == 58 || n == 64 || n == 38 || n == 61 || n == 43 || n == 36;
    }

    public static boolean is_ipath(int n) {
        return CodepointUtils.is_ipchar(n) || n == 59 || n == 47 || n == 37 || n == 44;
    }

    public static boolean is_ipathnodelims(int n) {
        return CodepointUtils.is_ipath(n) && !CodepointUtils.isGenDelim(n);
    }

    public static boolean is_iquery(int n) {
        return CodepointUtils.is_ipchar(n) || CodepointUtils.is_iprivate(n) || n == 59 || n == 47 || n == 63 || n == 37;
    }

    public static boolean is_ifragment(int n) {
        return CodepointUtils.is_ipchar(n) || CodepointUtils.is_iprivate(n) || n == 47 || n == 63 || n == 37;
    }

    public static boolean is_iregname(int n) {
        return CodepointUtils.is_iunreserved(n) || n == 33 || n == 36 || n == 38 || n == 39 || n == 40 || n == 41 || n == 42 || n == 43 || n == 44 || n == 59 || n == 61 || n == 34;
    }

    public static boolean is_ipliteral(int n) {
        return CodepointUtils.isHex(n) || n == 58 || n == 91 || n == 93;
    }

    public static boolean is_ihost(int n) {
        return CodepointUtils.is_iregname(n) || CodepointUtils.is_ipliteral(n);
    }

    public static boolean is_regname(int n) {
        return CodepointUtils.isUnreserved(n) || n == 33 || n == 36 || n == 38 || n == 39 || n == 40 || n == 41 || n == 42 || n == 43 || n == 44 || n == 59 || n == 61 || n == 34;
    }

    public static boolean is_iuserinfo(int n) {
        return CodepointUtils.is_iunreserved(n) || n == 59 || n == 58 || n == 38 || n == 61 || n == 43 || n == 36 || n == 44;
    }

    public static boolean is_iserver(int n) {
        return CodepointUtils.is_iuserinfo(n) || CodepointUtils.is_iregname(n) || CodepointUtils.isAlphaDigit(n) || n == 46 || n == 58 || n == 64 || n == 91 || n == 93 || n == 37 || n == 45;
    }

    public static void verify(AbstractCodepointIterator abstractCodepointIterator, ICodepointFilter iCodepointFilter) {
        CodepointIteratorRestricted codepointIteratorRestricted = abstractCodepointIterator.restrict(iCodepointFilter, false);
        while (codepointIteratorRestricted.hasNext()) {
            codepointIteratorRestricted.next();
        }
    }

    public static void verify(AbstractCodepointIterator abstractCodepointIterator, @Nonnull ECodepointProfile eCodepointProfile) {
        CodepointUtils.verify(abstractCodepointIterator, eCodepointProfile.getFilter());
    }

    public static void verify(@Nullable char[] cArray, @Nonnull ECodepointProfile eCodepointProfile) {
        if (cArray != null) {
            CodepointUtils.verify((AbstractCodepointIterator)new CodepointIteratorCharArray(cArray), eCodepointProfile);
        }
    }

    public static void verify(@Nullable String string, @Nonnull ECodepointProfile eCodepointProfile) {
        if (string != null) {
            CodepointUtils.verify((AbstractCodepointIterator)new CodepointIteratorCharSequence(string), eCodepointProfile);
        }
    }

    public static void verifyNot(ICodepointIterator iCodepointIterator, ICodepointFilter iCodepointFilter) {
        CodepointIteratorRestricted codepointIteratorRestricted = iCodepointIterator.restrict(iCodepointFilter, false, true);
        while (codepointIteratorRestricted.hasNext()) {
            codepointIteratorRestricted.next();
        }
    }

    public static void verifyNot(ICodepointIterator iCodepointIterator, @Nonnull ECodepointProfile eCodepointProfile) {
        CodepointIteratorRestricted codepointIteratorRestricted = iCodepointIterator.restrict(eCodepointProfile.getFilter(), false, true);
        while (codepointIteratorRestricted.hasNext()) {
            codepointIteratorRestricted.next();
        }
    }

    public static void verifyNot(char[] cArray, @Nonnull ECodepointProfile eCodepointProfile) {
        CodepointUtils.verifyNot((ICodepointIterator)new CodepointIteratorCharArray(cArray), eCodepointProfile);
    }
}

