/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterMatchNoRegEx
implements FilenameFilter {
    private final String[] m_aRegExs;

    public FilenameFilterMatchNoRegEx(@Nonnull @Nonempty String string) {
        this(new String[]{string});
    }

    public FilenameFilterMatchNoRegEx(String ... stringArray) {
        this.m_aRegExs = ArrayHelper.getCopy(ValueEnforcer.notEmpty(stringArray, "RegularExpressions"));
    }

    @Nonnull
    @ReturnsMutableCopy
    public String[] getRegularExpressions() {
        return ArrayHelper.getCopy(this.m_aRegExs);
    }

    @Override
    public boolean accept(@Nonnull File file, @Nonnull String string) {
        String string2 = FilenameHelper.getSecureFilename(string);
        if (string2 == null) {
            return false;
        }
        for (String string3 : this.m_aRegExs) {
            if (!RegExHelper.stringMatchesPattern(string3, string2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new ToStringGenerator(this).append("regExs", this.m_aRegExs).toString();
    }
}

