/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.collections.iterate.IIterableIterator;
import com.helger.commons.filter.IFilter;
import com.helger.commons.filter.collections.FilterIterator;
import com.helger.commons.io.file.FileUtils;
import com.helger.commons.io.file.filter.AbstractFileFilter;
import com.helger.commons.io.file.filter.FileFilterToIFilterAdapter;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileSystemRecursiveIterator
implements IIterableIterator<File> {
    private final int m_nStartLevel;
    private int m_nLevel = 0;
    private final IFilter<File> m_aRecursionFilter;
    private final List<File> m_aFilesLeft;

    @Nonnegative
    private static int _getLevel(@Nonnull File file) {
        return StringHelper.getCharCount(file.getAbsolutePath(), File.separatorChar);
    }

    public FileSystemRecursiveIterator(@Nonnull String string) {
        this(new File(string), (IFilter<File>)null);
    }

    public FileSystemRecursiveIterator(@Nonnull File file) {
        this(file, (IFilter<File>)null);
    }

    public FileSystemRecursiveIterator(@Nonnull String string, @Nullable FilenameFilter filenameFilter) {
        this(string, FileFilterToIFilterAdapter.create(filenameFilter));
    }

    public FileSystemRecursiveIterator(@Nonnull String string, @Nullable FileFilter fileFilter) {
        this(string, FileFilterToIFilterAdapter.create(fileFilter));
    }

    public FileSystemRecursiveIterator(@Nonnull String string, @Nullable AbstractFileFilter abstractFileFilter) {
        this(string, (IFilter<File>)abstractFileFilter);
    }

    public FileSystemRecursiveIterator(@Nonnull String string, @Nullable IFilter<File> iFilter) {
        this(new File(string), iFilter);
    }

    public FileSystemRecursiveIterator(@Nonnull File file, @Nullable FilenameFilter filenameFilter) {
        this(file, FileFilterToIFilterAdapter.create(filenameFilter));
    }

    public FileSystemRecursiveIterator(@Nonnull File file, @Nullable FileFilter fileFilter) {
        this(file, FileFilterToIFilterAdapter.create(fileFilter));
    }

    public FileSystemRecursiveIterator(@Nonnull File file, @Nullable AbstractFileFilter abstractFileFilter) {
        this(file, (IFilter<File>)abstractFileFilter);
    }

    public FileSystemRecursiveIterator(@Nonnull File file, @Nullable IFilter<File> iFilter) {
        ValueEnforcer.notNull(file, "BaseDirectory");
        this.m_nStartLevel = FileSystemRecursiveIterator._getLevel(file);
        this.m_aRecursionFilter = iFilter;
        this.m_aFilesLeft = FileUtils.getDirectoryContent(file);
    }

    @Override
    @Nonnull
    public final Iterator<File> iterator() {
        return this;
    }

    @Override
    public final boolean hasNext() {
        return !this.m_aFilesLeft.isEmpty();
    }

    @OverrideOnDemand
    protected boolean recurseIntoDirectory(@Nonnull File file) {
        return this.m_aRecursionFilter == null || this.m_aRecursionFilter.matchesFilter(file);
    }

    @Override
    @Nonnull
    public final File next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        File file = this.m_aFilesLeft.remove(0);
        this.m_nLevel = FileSystemRecursiveIterator._getLevel(file) - this.m_nStartLevel;
        if (file.isDirectory() && this.recurseIntoDirectory(file)) {
            this.m_aFilesLeft.addAll(0, FileUtils.getDirectoryContent(file));
        }
        return file;
    }

    @Nonnegative
    public final int getLevel() {
        return this.m_nLevel;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return new ToStringGenerator(this).append("files", this.m_aFilesLeft).toString();
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, @Nonnull FilenameFilter filenameFilter) {
        return FileSystemRecursiveIterator.create(new File(string), filenameFilter);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, @Nonnull FilenameFilter filenameFilter) {
        return new FilterIterator<File>(new FileSystemRecursiveIterator(file), (IFilter<File>)new FileFilterToIFilterAdapter(filenameFilter));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, FilenameFilter ... filenameFilterArray) {
        return FileSystemRecursiveIterator.create(new File(string), filenameFilterArray);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, FilenameFilter ... filenameFilterArray) {
        return new FilterIterator<File>(new FileSystemRecursiveIterator(file), FileFilterToIFilterAdapter.getANDChained(filenameFilterArray));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, @Nonnull FileFilter fileFilter) {
        return FileSystemRecursiveIterator.create(new File(string), fileFilter);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, @Nonnull FileFilter fileFilter) {
        return new FilterIterator<File>(new FileSystemRecursiveIterator(file), (IFilter<File>)new FileFilterToIFilterAdapter(fileFilter));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, FileFilter ... fileFilterArray) {
        return FileSystemRecursiveIterator.create(new File(string), fileFilterArray);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, FileFilter ... fileFilterArray) {
        return new FilterIterator<File>(new FileSystemRecursiveIterator(file), FileFilterToIFilterAdapter.getANDChained(fileFilterArray));
    }
}

