/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.monitor;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collections.NonBlockingStack;
import com.helger.commons.io.monitor.FileMonitor;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

final class FileMonitorAgent {
    private final FileMonitor m_aMonitor;
    private final File m_aFile;
    private boolean m_bExists;
    private long m_nTimestamp;
    private final Set<String> m_aChildren = new HashSet<String>();

    FileMonitorAgent(@Nonnull FileMonitor fileMonitor, @Nonnull File file) {
        this.m_aMonitor = ValueEnforcer.notNull(fileMonitor, "Monitor");
        this.m_aFile = ValueEnforcer.notNull(file, "File");
        this.m_bExists = file.exists();
        if (this.m_bExists) {
            this.m_nTimestamp = file.lastModified();
            this.resetChildrenList();
        } else {
            this.m_nTimestamp = -1L;
        }
    }

    void resetChildrenList() {
        this.m_aChildren.clear();
        File[] fileArray = this.m_aFile.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                this.m_aChildren.add(file.getAbsolutePath());
            }
        }
    }

    private void _onFileCreateRecursive(@Nonnull File file) {
        File[] fileArray;
        this.m_aMonitor.onFileCreated(file);
        if (this.m_aMonitor.isRecursive() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                this._onFileCreateRecursive(file2);
            }
        }
    }

    private void _checkForNewChildren() {
        HashSet<String> hashSet = new HashSet<String>();
        NonBlockingStack<File> nonBlockingStack = new NonBlockingStack<File>();
        File[] fileArray = this.m_aFile.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                String string = file.getAbsolutePath();
                hashSet.add(string);
                if (this.m_aChildren.contains(string)) continue;
                nonBlockingStack.push(file);
            }
        }
        this.m_aChildren.clear();
        this.m_aChildren.addAll(hashSet);
        while (!nonBlockingStack.isEmpty()) {
            this._onFileCreateRecursive((File)nonBlockingStack.pop());
        }
    }

    void checkForModifications() {
        boolean bl = this.m_aFile.exists();
        if (this.m_bExists) {
            if (!bl) {
                this.m_bExists = bl;
                this.m_nTimestamp = -1L;
                this.m_aMonitor.onFileDeleted(this.m_aFile);
            } else {
                long l = this.m_aFile.lastModified();
                if (this.m_nTimestamp != l) {
                    this.m_nTimestamp = l;
                    this.m_aMonitor.onFileChanged(this.m_aFile);
                }
            }
        } else if (bl) {
            this.m_bExists = bl;
            this.m_nTimestamp = this.m_aFile.lastModified();
            this.m_aMonitor.onFileCreated(this.m_aFile);
        }
        this._checkForNewChildren();
    }

    public String toString() {
        return new ToStringGenerator(this).append("file", this.m_aFile).append("exists", this.m_bExists).append("timestamp", this.m_nTimestamp).append("children", this.m_aChildren).toString();
    }
}

