/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.monitor;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.concurrent.ThreadUtils;
import com.helger.commons.io.monitor.FileMonitor;
import com.helger.commons.io.monitor.FileMonitorAgent;
import com.helger.commons.io.monitor.IFileListener;
import com.helger.commons.state.EChange;
import com.helger.commons.timing.StopWatch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMonitorManager
implements Runnable {
    public static final long DEFAULT_DELAY = 1000L;
    public static final int DEFAULT_MAX_FILES = 1000;
    private static final Logger s_aLogger = LoggerFactory.getLogger(FileMonitorManager.class);
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final List<FileMonitor> m_aMonitorList = new ArrayList<FileMonitor>();
    private Thread m_aMonitorThread;
    private volatile boolean m_bShouldRun = true;
    private long m_nDelay = 1000L;
    private int m_nChecksPerRun = 1000;

    public long getDelay() {
        return this.m_nDelay;
    }

    @Nonnull
    public FileMonitorManager setDelay(long l) {
        this.m_nDelay = l > 0L ? l : 1000L;
        return this;
    }

    public int getChecksPerRun() {
        return this.m_nChecksPerRun;
    }

    @Nonnull
    public FileMonitorManager setChecksPerRun(int n) {
        this.m_nChecksPerRun = n;
        return this;
    }

    @Nonnull
    public FileMonitor createFileMonitor(@Nonnull IFileListener iFileListener) {
        FileMonitor fileMonitor = new FileMonitor(iFileListener);
        this.addFileMonitor(fileMonitor);
        return fileMonitor;
    }

    public void addFileMonitor(@Nonnull FileMonitor fileMonitor) {
        ValueEnforcer.notNull(fileMonitor, "Monitor");
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMonitorList.add(fileMonitor);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    public EChange removeFileMonitor(@Nullable FileMonitor fileMonitor) {
        if (fileMonitor == null) {
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(this.m_aMonitorList.remove(fileMonitor));
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<FileMonitor> getAllFileMonitors() {
        this.m_aRWLock.readLock().lock();
        try {
            List<FileMonitor> list = ContainerHelper.newList(this.m_aMonitorList);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nonnegative
    public int getFileMonitorCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aMonitorList.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    public void start() {
        if (this.m_aMonitorThread != null || !this.m_bShouldRun) {
            throw new IllegalStateException("Thread is already running!");
        }
        this.m_aMonitorThread = new Thread((Runnable)this, "FileMonitor");
        this.m_aMonitorThread.setDaemon(true);
        this.m_aMonitorThread.setPriority(1);
        this.m_aMonitorThread.start();
        s_aLogger.info("Started FileMonitor thread");
    }

    public void stop() {
        if (this.m_aMonitorThread != null) {
            this.m_bShouldRun = false;
            this.m_aMonitorThread = null;
            s_aLogger.info("Stopped FileMonitor thread");
        }
    }

    public boolean isRunning() {
        return this.m_aMonitorThread != null && this.m_bShouldRun;
    }

    @Override
    public void run() {
        block0: while (this.m_aMonitorThread != null && !this.m_aMonitorThread.isInterrupted() && this.m_bShouldRun) {
            StopWatch stopWatch = new StopWatch(true);
            int n = 0;
            for (FileMonitor fileMonitor : this.getAllFileMonitors()) {
                fileMonitor.applyPendingRemovals();
                for (FileMonitorAgent fileMonitorAgent : fileMonitor.getAllAgents()) {
                    fileMonitorAgent.checkForModifications();
                    int n2 = this.getChecksPerRun();
                    if (n2 > 0 && n % n2 == 0) {
                        ThreadUtils.sleep(this.getDelay());
                    }
                    if (this.m_aMonitorThread == null || this.m_aMonitorThread.isInterrupted() || !this.m_bShouldRun) break block0;
                    ++n;
                }
                fileMonitor.applyPendingAdds();
            }
            ThreadUtils.sleep(this.getDelay());
            if (!s_aLogger.isDebugEnabled()) continue;
            s_aLogger.debug("Checking for file modifications took " + stopWatch.stopAndGetMillis() + " ms");
        }
        this.m_bShouldRun = true;
    }
}

