/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resourceprovider;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.io.IReadableResource;
import com.helger.commons.io.IWritableResource;
import com.helger.commons.io.IWritableResourceProvider;
import com.helger.commons.io.file.FileUtils;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class FileSystemResourceProvider
implements IWritableResourceProvider {
    private static final Logger s_aLogger = LoggerFactory.getLogger(FileSystemResourceProvider.class);
    private final File m_aBasePath;

    public FileSystemResourceProvider() {
        this((File)null);
    }

    public FileSystemResourceProvider(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemResourceProvider(@Nullable File file) {
        if (file != null) {
            if (!file.exists()) {
                throw new IllegalArgumentException("Passed base path '" + file + "' does not exist!");
            }
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("Passed base path '" + file + "' is not a directory!");
            }
            if (!FileUtils.canRead(file)) {
                s_aLogger.warn("Cannot read passed base path '" + file + "'!");
            }
            if (!FileUtils.canWrite(file)) {
                s_aLogger.warn("Cannot write passed base path '" + file + "'!");
            }
            if (!FileUtils.canExecute(file)) {
                s_aLogger.warn("Cannot execute in passed base path '" + file + "'!");
            }
        }
        this.m_aBasePath = file;
    }

    @Nullable
    public File getBasePath() {
        return this.m_aBasePath;
    }

    @Nonnull
    private File _getFile(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Name");
        return this.m_aBasePath == null ? new File(string) : new File(this.m_aBasePath, string);
    }

    @Override
    public boolean supportsReading(@Nullable String string) {
        if (ClassPathResource.isExplicitClassPathResource(string)) {
            return false;
        }
        if (URLResource.isExplicitURLResource(string)) {
            return false;
        }
        return StringHelper.hasText(string) && this._getFile(string).isAbsolute();
    }

    @Override
    public boolean supportsWriting(@Nullable String string) {
        if (ClassPathResource.isExplicitClassPathResource(string)) {
            return false;
        }
        if (URLResource.isExplicitURLResource(string)) {
            return false;
        }
        return StringHelper.hasText(string);
    }

    @Override
    @Nonnull
    public IReadableResource getReadableResource(@Nonnull String string) {
        return new FileSystemResource(this._getFile(string));
    }

    @Override
    @Nonnull
    public IWritableResource getWritableResource(@Nonnull String string) {
        return new FileSystemResource(this._getFile(string));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FileSystemResourceProvider)) {
            return false;
        }
        FileSystemResourceProvider fileSystemResourceProvider = (FileSystemResourceProvider)object;
        return EqualsUtils.equals(this.m_aBasePath, fileSystemResourceProvider.m_aBasePath);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aBasePath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("basePath", this.m_aBasePath).toString();
    }
}

