/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streamprovider;

import com.helger.commons.annotations.DevelopersNote;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IOutputStreamAndWriterProvider;
import com.helger.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.string.ToStringGenerator;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public class ByteArrayOutputStreamProvider
implements IOutputStreamAndWriterProvider,
Serializable {
    private final NonBlockingByteArrayOutputStream m_aOS = new NonBlockingByteArrayOutputStream();

    @Override
    @Nonnull
    public final NonBlockingByteArrayOutputStream getOutputStream(@Nonnull EAppend eAppend) {
        if (eAppend.isTruncate()) {
            this.m_aOS.reset();
        }
        return this.m_aOS;
    }

    @Override
    @Nonnull
    @Deprecated
    public final OutputStreamWriter getWriter(@Nonnull String string, @Nonnull EAppend eAppend) {
        return StreamUtils.createWriter((OutputStream)this.getOutputStream(eAppend), string);
    }

    @Override
    @Nonnull
    public final OutputStreamWriter getWriter(@Nonnull Charset charset, @Nonnull EAppend eAppend) {
        return StreamUtils.createWriter((OutputStream)this.getOutputStream(eAppend), charset);
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getBytes() {
        return this.m_aOS.toByteArray();
    }

    @Nonnull
    @Deprecated
    public String getAsString(@Nonnull String string) {
        return this.m_aOS.getAsString(string);
    }

    @Nonnull
    public String getAsString(@Nonnull Charset charset) {
        return this.m_aOS.getAsString(charset);
    }

    @Deprecated
    @DevelopersNote(value="Most probably you wanted to call getAsString")
    public String toString() {
        return new ToStringGenerator(this).append("os", this.m_aOS).toString();
    }
}

