/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streams;

import com.helger.commons.io.streams.NonBlockingBitInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

public class BitInputStream
extends NonBlockingBitInputStream {
    private final Lock m_aLock = new ReentrantLock();

    public BitInputStream(@Nonnull InputStream inputStream, @Nonnull ByteOrder byteOrder) {
        super(inputStream, byteOrder);
    }

    @Override
    public int readBit() throws IOException {
        this.m_aLock.lock();
        try {
            int n = super.readBit();
            return n;
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    @Override
    public void close() {
        this.m_aLock.lock();
        try {
            super.close();
        }
        finally {
            this.m_aLock.unlock();
        }
    }
}

