/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streams;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.callback.INonThrowingRunnableWithParameter;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.io.IInputStreamProvider;
import com.helger.commons.io.streams.ByteBufferInputStream;
import com.helger.commons.io.streams.ByteBufferOutputStream;
import com.helger.commons.io.streams.NonBlockingBufferedInputStream;
import com.helger.commons.io.streams.NonBlockingBufferedOutputStream;
import com.helger.commons.io.streams.NonBlockingBufferedReader;
import com.helger.commons.io.streams.NonBlockingBufferedWriter;
import com.helger.commons.io.streams.NonBlockingByteArrayInputStream;
import com.helger.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.streams.NonBlockingStringReader;
import com.helger.commons.io.streams.NonBlockingStringWriter;
import com.helger.commons.io.streams.WrappedInputStream;
import com.helger.commons.io.streams.WrappedOutputStream;
import com.helger.commons.io.streams.WrappedReader;
import com.helger.commons.io.streams.WrappedWriter;
import com.helger.commons.mock.IMockException;
import com.helger.commons.mutable.MutableLong;
import com.helger.commons.state.ESuccess;
import com.helger.commons.stats.IStatisticsHandlerSize;
import com.helger.commons.stats.StatisticsManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class StreamUtils {
    private static final int DEFAULT_BUFSIZE = 16384;
    private static final Logger s_aLogger = LoggerFactory.getLogger(StreamUtils.class);
    private static final IStatisticsHandlerSize s_aByteSizeHdl = StatisticsManager.getSizeHandler(StreamUtils.class.getName() + "$COPY");
    private static final IStatisticsHandlerSize s_aCharSizeHdl = StatisticsManager.getSizeHandler(StreamUtils.class.getName() + "$COPYCHARS");
    private static final StreamUtils s_aInstance = new StreamUtils();

    private StreamUtils() {
    }

    public static boolean isKnownEOFException(@Nullable Throwable throwable) {
        return throwable != null && StreamUtils.isKnownEOFException(throwable.getClass());
    }

    public static boolean isKnownEOFException(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        String string = clazz.getName();
        return string.equals("java.io.EOFException") || string.equals("org.mortbay.jetty.EofException") || string.equals("org.eclipse.jetty.io.EofException") || string.equals("org.apache.catalina.connector.ClientAbortException");
    }

    @Nonnull
    public static ESuccess closeWithoutFlush(@Nullable @WillClose Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                    return ESuccess.SUCCESS;
                }
                catch (IOException iOException) {
                    if (StreamUtils.isKnownEOFException(iOException)) break block3;
                    s_aLogger.error("Failed to close stream " + closeable.getClass().getName(), (Throwable)(iOException instanceof IMockException ? null : iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess close(@Nullable @WillClose Closeable closeable) {
        block5: {
            if (closeable != null) {
                try {
                    if (closeable instanceof Flushable) {
                        StreamUtils.flush((Flushable)((Object)closeable));
                    }
                    closeable.close();
                    return ESuccess.SUCCESS;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IOException iOException) {
                    if (StreamUtils.isKnownEOFException(iOException)) break block5;
                    s_aLogger.error("Failed to close object " + closeable.getClass().getName(), (Throwable)(iOException instanceof IMockException ? null : iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess close(@Nullable @WillClose Socket socket) {
        block3: {
            if (socket != null && !socket.isClosed()) {
                try {
                    socket.close();
                    return ESuccess.SUCCESS;
                }
                catch (IOException iOException) {
                    if (StreamUtils.isKnownEOFException(iOException)) break block3;
                    s_aLogger.error("Failed to close socket " + socket.getClass().getName(), (Throwable)(iOException instanceof IMockException ? null : iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess close(@Nullable @WillClose ServerSocket serverSocket) {
        block3: {
            if (serverSocket != null && !serverSocket.isClosed()) {
                try {
                    serverSocket.close();
                    return ESuccess.SUCCESS;
                }
                catch (IOException iOException) {
                    if (StreamUtils.isKnownEOFException(iOException)) break block3;
                    s_aLogger.error("Failed to close server socket " + serverSocket.getClass().getName(), (Throwable)(iOException instanceof IMockException ? null : iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess flush(@Nullable Flushable flushable) {
        block4: {
            if (flushable != null) {
                try {
                    flushable.flush();
                    return ESuccess.SUCCESS;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IOException iOException) {
                    if (StreamUtils.isKnownEOFException(iOException)) break block4;
                    s_aLogger.error("Failed to flush object " + flushable.getClass().getName(), (Throwable)(iOException instanceof IMockException ? null : iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamAndCloseOS(@WillClose @Nullable InputStream inputStream, @WillClose @Nullable OutputStream outputStream) {
        try {
            ESuccess eSuccess = StreamUtils.copyInputStreamToOutputStream(inputStream, outputStream, new byte[16384], null, null);
            return eSuccess;
        }
        finally {
            StreamUtils.close(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamWithLimitAndCloseOS(@WillClose @Nullable InputStream inputStream, @WillClose @Nullable OutputStream outputStream, @Nonnegative long l) {
        try {
            ESuccess eSuccess = StreamUtils.copyInputStreamToOutputStream(inputStream, outputStream, new byte[16384], null, l);
            return eSuccess;
        }
        finally {
            StreamUtils.close(outputStream);
        }
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream) {
        return StreamUtils.copyInputStreamToOutputStream(inputStream, outputStream, new byte[16384], null, null);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nullable MutableLong mutableLong) {
        return StreamUtils.copyInputStreamToOutputStream(inputStream, outputStream, new byte[16384], mutableLong, null);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamWithLimit(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nonnegative long l) {
        return StreamUtils.copyInputStreamToOutputStream(inputStream, outputStream, new byte[16384], null, l);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nonnull byte[] byArray) {
        return StreamUtils.copyInputStreamToOutputStream(inputStream, outputStream, byArray, null, null);
    }

    @Nonnegative
    private static long _copyInputStreamToOutputStream(@Nonnull @WillNotClose InputStream inputStream, @Nonnull @WillNotClose OutputStream outputStream, @Nonnull @WillNotClose byte[] byArray) throws IOException {
        int n;
        long l = 0L;
        while ((n = inputStream.read(byArray, 0, byArray.length)) > -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    @Nonnegative
    private static long _copyInputStreamToOutputStreamWithLimit(@Nonnull @WillNotClose InputStream inputStream, @Nonnull @WillNotClose OutputStream outputStream, @Nonnull byte[] byArray, @Nonnegative long l) throws IOException {
        long l2 = l;
        long l3 = 0L;
        while (true) {
            int n;
            int n2;
            int n3 = n2 = l2 >= (long)byArray.length ? byArray.length : (int)l2;
            if (n2 == 0 || (n = inputStream.read(byArray, 0, n2)) == -1) break;
            if (n <= 0) continue;
            outputStream.write(byArray, 0, n);
            l3 += (long)n;
            l2 -= (long)n;
        }
        return l3;
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nonnull @Nonempty byte[] byArray, @Nullable MutableLong mutableLong) {
        return StreamUtils.copyInputStreamToOutputStream(inputStream, outputStream, byArray, mutableLong, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nonnull @Nonempty byte[] byArray, @Nullable MutableLong mutableLong, @Nullable Long l) {
        ValueEnforcer.notEmpty(byArray, "Buffer");
        if (l != null && l < 0L) {
            throw new IllegalArgumentException("Limit may not be negative!");
        }
        try {
            if (inputStream != null && outputStream != null) {
                long l2 = l == null ? StreamUtils._copyInputStreamToOutputStream(inputStream, outputStream, byArray) : StreamUtils._copyInputStreamToOutputStreamWithLimit(inputStream, outputStream, byArray, l);
                s_aByteSizeHdl.addSize(l2);
                if (mutableLong != null) {
                    mutableLong.set(l2);
                }
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (IOException iOException) {
            if (!StreamUtils.isKnownEOFException(iOException)) {
                s_aLogger.error("Failed to copy from stream to stream", (Throwable)(iOException instanceof IMockException ? null : iOException));
            }
        }
        finally {
            StreamUtils.close(inputStream);
        }
        return ESuccess.FAILURE;
    }

    public static int getAvailable(@Nullable InputStream inputStream) {
        if (inputStream != null) {
            try {
                return inputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Nonnull
    public static NonBlockingByteArrayOutputStream getCopy(@Nonnull @WillClose InputStream inputStream) {
        int n = Math.max(16384, StreamUtils.getAvailable(inputStream));
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(n);
        StreamUtils.copyInputStreamToOutputStreamAndCloseOS(inputStream, nonBlockingByteArrayOutputStream);
        return nonBlockingByteArrayOutputStream;
    }

    @Nonnull
    public static NonBlockingByteArrayOutputStream getCopyWithLimit(@Nonnull @WillClose InputStream inputStream, @Nonnegative long l) {
        int n = Math.max(16384, StreamUtils.getAvailable(inputStream));
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(n);
        StreamUtils.copyInputStreamToOutputStreamWithLimitAndCloseOS(inputStream, nonBlockingByteArrayOutputStream, l);
        return nonBlockingByteArrayOutputStream;
    }

    @Nullable
    public static byte[] getAllBytes(@Nullable IInputStreamProvider iInputStreamProvider) {
        if (iInputStreamProvider == null) {
            return null;
        }
        return StreamUtils.getAllBytes(iInputStreamProvider.getInputStream());
    }

    @Nullable
    public static byte[] getAllBytes(@Nullable @WillClose InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        return StreamUtils.getCopy(inputStream).toByteArray();
    }

    @Nullable
    @Deprecated
    public static String getAllBytesAsString(@Nullable IInputStreamProvider iInputStreamProvider, @Nonnull @Nonempty String string) {
        if (iInputStreamProvider == null) {
            return null;
        }
        return StreamUtils.getAllBytesAsString(iInputStreamProvider.getInputStream(), string);
    }

    @Nullable
    public static String getAllBytesAsString(@Nullable IInputStreamProvider iInputStreamProvider, @Nonnull @Nonempty Charset charset) {
        if (iInputStreamProvider == null) {
            return null;
        }
        return StreamUtils.getAllBytesAsString(iInputStreamProvider.getInputStream(), charset);
    }

    @Nullable
    @Deprecated
    public static String getAllBytesAsString(@Nullable @WillClose InputStream inputStream, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Charset");
        if (inputStream == null) {
            return null;
        }
        return StreamUtils.getCopy(inputStream).getAsString(string);
    }

    @Nullable
    public static String getAllBytesAsString(@Nullable @WillClose InputStream inputStream, @Nonnull @Nonempty Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        if (inputStream == null) {
            return null;
        }
        return StreamUtils.getCopy(inputStream).getAsString(charset);
    }

    @Nonnull
    public static ESuccess copyReaderToWriterAndCloseWriter(@WillClose @Nullable Reader reader, @WillClose @Nullable Writer writer) {
        try {
            ESuccess eSuccess = StreamUtils.copyReaderToWriter(reader, writer, new char[16384], null, null);
            return eSuccess;
        }
        finally {
            StreamUtils.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyReaderToWriterWithLimitAndCloseWriter(@WillClose @Nullable Reader reader, @WillClose @Nullable Writer writer, @Nonnegative long l) {
        try {
            ESuccess eSuccess = StreamUtils.copyReaderToWriter(reader, writer, new char[16384], null, l);
            return eSuccess;
        }
        finally {
            StreamUtils.close(writer);
        }
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer) {
        return StreamUtils.copyReaderToWriter(reader, writer, new char[16384], null, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, @Nullable MutableLong mutableLong) {
        return StreamUtils.copyReaderToWriter(reader, writer, new char[16384], mutableLong, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, @Nonnull char[] cArray) {
        return StreamUtils.copyReaderToWriter(reader, writer, cArray, null, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriterWithLimit(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, long l) {
        return StreamUtils.copyReaderToWriter(reader, writer, new char[16384], null, l);
    }

    @Nonnegative
    private static long _copyReaderToWriter(@Nonnull Reader reader, @Nonnull Writer writer, @Nonnull char[] cArray) throws IOException {
        int n;
        long l = 0L;
        while ((n = reader.read(cArray, 0, cArray.length)) > -1) {
            writer.write(cArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    @Nonnegative
    private static long _copyReaderToWriterWithLimit(@Nonnull Reader reader, @Nonnull Writer writer, @Nonnull char[] cArray, @Nonnegative long l) throws IOException {
        long l2 = l;
        long l3 = 0L;
        while (true) {
            int n;
            int n2;
            int n3 = n2 = l2 >= (long)cArray.length ? cArray.length : (int)l2;
            if (n2 == 0 || (n = reader.read(cArray, 0, n2)) == -1) break;
            if (n <= 0) continue;
            writer.write(cArray, 0, n);
            l3 += (long)n;
            l2 -= (long)n;
        }
        return l3;
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, @Nonnull @Nonempty char[] cArray, @Nullable MutableLong mutableLong) {
        return StreamUtils.copyReaderToWriter(reader, writer, cArray, mutableLong, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, @Nonnull @Nonempty char[] cArray, @Nullable MutableLong mutableLong, @Nullable Long l) {
        ValueEnforcer.notEmpty(cArray, "Buffer");
        if (l != null && l < 0L) {
            throw new IllegalArgumentException("Limit may not be negative!");
        }
        try {
            if (reader != null && writer != null) {
                long l2 = l == null ? StreamUtils._copyReaderToWriter(reader, writer, cArray) : StreamUtils._copyReaderToWriterWithLimit(reader, writer, cArray, l);
                s_aCharSizeHdl.addSize(l2);
                if (mutableLong != null) {
                    mutableLong.set(l2);
                }
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (IOException iOException) {
            if (!StreamUtils.isKnownEOFException(iOException)) {
                s_aLogger.error("Failed to copy from reader to writer", (Throwable)(iOException instanceof IMockException ? null : iOException));
            }
        }
        finally {
            StreamUtils.close(reader);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static NonBlockingStringWriter getCopy(@Nonnull @WillClose Reader reader) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(16384);
        StreamUtils.copyReaderToWriterAndCloseWriter(reader, nonBlockingStringWriter);
        return nonBlockingStringWriter;
    }

    @Nonnull
    public static NonBlockingStringWriter getCopyWithLimit(@Nonnull @WillClose Reader reader, @Nonnegative long l) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(16384);
        StreamUtils.copyReaderToWriterWithLimitAndCloseWriter(reader, nonBlockingStringWriter, l);
        return nonBlockingStringWriter;
    }

    @Nullable
    public static char[] getAllCharacters(@Nullable @WillClose Reader reader) {
        if (reader == null) {
            return null;
        }
        return StreamUtils.getCopy(reader).getAsCharArray();
    }

    @Nullable
    public static String getAllCharactersAsString(@Nullable @WillClose Reader reader) {
        if (reader == null) {
            return null;
        }
        return StreamUtils.getCopy(reader).getAsString();
    }

    @Nullable
    @Deprecated
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@Nullable IInputStreamProvider iInputStreamProvider, @Nonnull @Nonempty String string) {
        return StreamUtils.readStreamLines(iInputStreamProvider, string, 0, -1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@Nullable IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset) {
        return StreamUtils.readStreamLines(iInputStreamProvider, charset, 0, -1);
    }

    @Nullable
    @Deprecated
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@Nullable IInputStreamProvider iInputStreamProvider, @Nonnull @Nonempty String string, @Nonnegative int n, int n2) {
        if (iInputStreamProvider == null) {
            return null;
        }
        return StreamUtils.readStreamLines(iInputStreamProvider.getInputStream(), string, n, n2);
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@Nullable IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnegative int n, int n2) {
        if (iInputStreamProvider == null) {
            return null;
        }
        return StreamUtils.readStreamLines(iInputStreamProvider.getInputStream(), charset, n, n2);
    }

    @Nullable
    @Deprecated
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty String string) {
        return StreamUtils.readStreamLines(inputStream, string, 0, -1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty Charset charset) {
        return StreamUtils.readStreamLines(inputStream, charset, 0, -1);
    }

    @Deprecated
    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty String string, final @Nonnull List<String> list) {
        if (inputStream != null) {
            StreamUtils.readStreamLines(inputStream, string, 0, -1, new INonThrowingRunnableWithParameter<String>(){

                @Override
                public void run(String string) {
                    list.add(string);
                }
            });
        }
    }

    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull Charset charset, final @Nonnull List<String> list) {
        if (inputStream != null) {
            StreamUtils.readStreamLines(inputStream, charset, 0, -1, new INonThrowingRunnableWithParameter<String>(){

                @Override
                public void run(String string) {
                    list.add(string);
                }
            });
        }
    }

    @Nullable
    @Deprecated
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty String string, @Nonnegative int n, int n2) {
        if (inputStream == null) {
            return null;
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        StreamUtils.readStreamLines(inputStream, string, n, n2, new INonThrowingRunnableWithParameter<String>(){

            @Override
            public void run(String string) {
                arrayList.add(string);
            }
        });
        return arrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<String> readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull Charset charset, @Nonnegative int n, int n2) {
        if (inputStream == null) {
            return null;
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        StreamUtils.readStreamLines(inputStream, charset, n, n2, new INonThrowingRunnableWithParameter<String>(){

            @Override
            public void run(String string) {
                arrayList.add(string);
            }
        });
        return arrayList;
    }

    @Deprecated
    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty String string, @Nonnull INonThrowingRunnableWithParameter<String> iNonThrowingRunnableWithParameter) {
        StreamUtils.readStreamLines(inputStream, string, 0, -1, iNonThrowingRunnableWithParameter);
    }

    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty Charset charset, @Nonnull INonThrowingRunnableWithParameter<String> iNonThrowingRunnableWithParameter) {
        StreamUtils.readStreamLines(inputStream, charset, 0, -1, iNonThrowingRunnableWithParameter);
    }

    private static void _readFromReader(int n, int n2, INonThrowingRunnableWithParameter<String> iNonThrowingRunnableWithParameter, boolean bl, NonBlockingBufferedReader nonBlockingBufferedReader) throws IOException {
        String string;
        int n3;
        for (n3 = 0; n3 < n && (string = nonBlockingBufferedReader.readLine()) != null; ++n3) {
        }
        if (bl) {
            while ((string = nonBlockingBufferedReader.readLine()) != null) {
                iNonThrowingRunnableWithParameter.run(string);
            }
        } else {
            n3 = 0;
            while ((string = nonBlockingBufferedReader.readLine()) != null) {
                iNonThrowingRunnableWithParameter.run(string);
                if (++n3 < n2) continue;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty Charset charset, @Nonnegative int n, int n2, @Nonnull INonThrowingRunnableWithParameter<String> iNonThrowingRunnableWithParameter) {
        block9: {
            boolean bl;
            ValueEnforcer.notNull(charset, "Charset");
            ValueEnforcer.isGE0(n, "LinesToSkip");
            boolean bl2 = bl = n2 == -1;
            if (n2 < 0 && !bl) {
                throw new IllegalArgumentException("Line count may not be that negative: " + n2);
            }
            ValueEnforcer.notNull(iNonThrowingRunnableWithParameter, "LineCallback");
            if (inputStream != null) {
                try {
                    if (!bl && n2 <= 0) break block9;
                    NonBlockingBufferedReader nonBlockingBufferedReader = null;
                    try {
                        nonBlockingBufferedReader = new NonBlockingBufferedReader(StreamUtils.createReader(inputStream, charset));
                        StreamUtils._readFromReader(n, n2, iNonThrowingRunnableWithParameter, bl, nonBlockingBufferedReader);
                    }
                    catch (IOException iOException) {
                        try {
                            s_aLogger.error("Failed to read from input stream", (Throwable)(iOException instanceof IMockException ? null : iOException));
                        }
                        catch (Throwable throwable) {
                            StreamUtils.close(nonBlockingBufferedReader);
                            throw throwable;
                        }
                        StreamUtils.close(nonBlockingBufferedReader);
                        break block9;
                    }
                    StreamUtils.close(nonBlockingBufferedReader);
                }
                finally {
                    StreamUtils.close(inputStream);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty String string, @Nonnegative int n, int n2, @Nonnull INonThrowingRunnableWithParameter<String> iNonThrowingRunnableWithParameter) {
        block9: {
            boolean bl;
            ValueEnforcer.notNull(string, "Charset");
            ValueEnforcer.isGE0(n, "LinesToSkip");
            boolean bl2 = bl = n2 == -1;
            if (n2 < 0 && !bl) {
                throw new IllegalArgumentException("Line count may not be that negative: " + n2);
            }
            ValueEnforcer.notNull(iNonThrowingRunnableWithParameter, "LineCallback");
            if (inputStream != null) {
                try {
                    if (!bl && n2 <= 0) break block9;
                    NonBlockingBufferedReader nonBlockingBufferedReader = null;
                    try {
                        nonBlockingBufferedReader = new NonBlockingBufferedReader(StreamUtils.createReader(inputStream, string));
                        StreamUtils._readFromReader(n, n2, iNonThrowingRunnableWithParameter, bl, nonBlockingBufferedReader);
                    }
                    catch (IOException iOException) {
                        try {
                            s_aLogger.error("Failed to read from input stream", (Throwable)(iOException instanceof IMockException ? null : iOException));
                        }
                        catch (Throwable throwable) {
                            StreamUtils.close(nonBlockingBufferedReader);
                            throw throwable;
                        }
                        StreamUtils.close(nonBlockingBufferedReader);
                        break block9;
                    }
                    StreamUtils.close(nonBlockingBufferedReader);
                }
                finally {
                    StreamUtils.close(inputStream);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(outputStream, "OutputStream");
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        try {
            outputStream.write(byArray, n, n2);
            outputStream.flush();
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (IOException iOException) {
            s_aLogger.error("Failed to write to output stream", (Throwable)(iOException instanceof IMockException ? null : iOException));
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamUtils.close(outputStream);
        }
    }

    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull byte[] byArray) {
        return StreamUtils.writeStream(outputStream, byArray, 0, byArray.length);
    }

    @Nonnull
    @Deprecated
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notNull(string, "Content");
        ValueEnforcer.notEmpty(string2, "Charset");
        return StreamUtils.writeStream(outputStream, CharsetManager.getAsBytes(string, string2));
    }

    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Content");
        ValueEnforcer.notNull(charset, "Charset");
        return StreamUtils.writeStream(outputStream, CharsetManager.getAsBytes(string, charset));
    }

    @Nonnull
    public static NonBlockingStringReader createReader(@Nonnull String string) {
        return new NonBlockingStringReader(string);
    }

    @Nonnull
    public static NonBlockingStringReader createReader(@Nonnull char[] cArray) {
        return new NonBlockingStringReader(cArray);
    }

    @Nullable
    @Deprecated
    public static InputStreamReader createReader(@Nullable InputStream inputStream, @Nonnull String string) {
        try {
            return inputStream == null ? null : new InputStreamReader(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Failed to create Reader for charset '" + string + "'", unsupportedEncodingException);
        }
    }

    @Nullable
    public static InputStreamReader createReader(@Nullable InputStream inputStream, @Nonnull Charset charset) {
        return inputStream == null ? null : new InputStreamReader(inputStream, charset);
    }

    @Nullable
    @Deprecated
    public static OutputStreamWriter createWriter(@Nullable OutputStream outputStream, @Nonnull String string) {
        try {
            return outputStream == null ? null : new OutputStreamWriter(outputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Failed to create Writer for charset '" + string + "'", unsupportedEncodingException);
        }
    }

    @Nullable
    public static OutputStreamWriter createWriter(@Nullable OutputStream outputStream, @Nonnull Charset charset) {
        return outputStream == null ? null : new OutputStreamWriter(outputStream, charset);
    }

    public static void skipFully(@Nonnull InputStream inputStream, @Nonnegative long l) throws IOException {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.isGE0(l, "BytesToSkip");
        long l2 = l;
        while (l2 > 0L) {
            long l3 = inputStream.skip(l2);
            if (l3 == 0L) {
                if (inputStream.read() == -1) {
                    throw new EOFException("Failed to skip a total of " + l + " bytes on input stream. Only skipped " + (l - l2) + " bytes so far!");
                }
                --l2;
                continue;
            }
            l2 -= l3;
        }
    }

    public static void readFully(@Nonnull InputStream inputStream, @Nonnull byte[] byArray) throws IOException {
        StreamUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    @Nonnegative
    public static int readFully(@Nonnull InputStream inputStream, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        int n3;
        int n4;
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 >= 0) continue;
            throw new EOFException("Failed to read a total of " + n2 + " bytes from input stream. Only read " + n3 + " bytes so far.");
        }
        return n3;
    }

    public static boolean isBuffered(@Nullable InputStream inputStream) {
        return inputStream instanceof BufferedInputStream || inputStream instanceof NonBlockingBufferedInputStream || inputStream instanceof ByteArrayInputStream || inputStream instanceof NonBlockingByteArrayInputStream || inputStream instanceof ByteBufferInputStream || inputStream instanceof WrappedInputStream && StreamUtils.isBuffered(((WrappedInputStream)inputStream).getWrappedInputStream());
    }

    @Nullable
    public static InputStream getBuffered(@Nullable InputStream inputStream) {
        return inputStream == null || StreamUtils.isBuffered(inputStream) ? inputStream : new NonBlockingBufferedInputStream(inputStream);
    }

    public static boolean isBuffered(@Nullable OutputStream outputStream) {
        return outputStream instanceof BufferedOutputStream || outputStream instanceof NonBlockingBufferedOutputStream || outputStream instanceof ByteArrayOutputStream || outputStream instanceof NonBlockingByteArrayOutputStream || outputStream instanceof ByteBufferOutputStream || outputStream instanceof WrappedOutputStream && StreamUtils.isBuffered(((WrappedOutputStream)outputStream).getWrappedOutputStream());
    }

    @Nullable
    public static OutputStream getBuffered(@Nullable OutputStream outputStream) {
        return outputStream == null || StreamUtils.isBuffered(outputStream) ? outputStream : new NonBlockingBufferedOutputStream(outputStream);
    }

    public static boolean isBuffered(@Nullable Reader reader) {
        return reader instanceof BufferedReader || reader instanceof NonBlockingBufferedReader || reader instanceof StringReader || reader instanceof NonBlockingStringReader || reader instanceof WrappedReader && StreamUtils.isBuffered(((WrappedReader)reader).getWrappedReader());
    }

    @Nullable
    public static Reader getBuffered(@Nullable Reader reader) {
        return reader == null || StreamUtils.isBuffered(reader) ? reader : new NonBlockingBufferedReader(reader);
    }

    public static boolean isBuffered(@Nullable Writer writer) {
        return writer instanceof BufferedWriter || writer instanceof NonBlockingBufferedWriter || writer instanceof StringWriter || writer instanceof NonBlockingStringWriter || writer instanceof WrappedWriter && StreamUtils.isBuffered(((WrappedWriter)writer).getWrappedWriter());
    }

    @Nullable
    public static Writer getBuffered(@Nullable Writer writer) {
        return writer == null || StreamUtils.isBuffered(writer) ? writer : new NonBlockingBufferedWriter(writer);
    }
}

