/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.locale;

import com.helger.commons.CGlobal;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.locale.LocaleUtils;
import com.helger.commons.string.StringHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LocaleCache {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LocaleCache.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<String, Locale> s_aLocales = new HashMap<String, Locale>();
    private static final LocaleCache s_aInstance;

    private static void _initialAdd(@Nonnull Locale locale) {
        s_aLocales.put(locale.toString(), locale);
    }

    private static void _initialFillCache() {
        LocaleCache._initialAdd(CGlobal.LOCALE_ALL);
        LocaleCache._initialAdd(CGlobal.LOCALE_INDEPENDENT);
        for (Locale object : Locale.getAvailableLocales()) {
            LocaleCache._initialAdd(object);
        }
        for (String string : Locale.getISOCountries()) {
            LocaleCache._initialAdd(new Locale("", string));
        }
        for (String string : Locale.getISOLanguages()) {
            LocaleCache._initialAdd(new Locale(string, ""));
        }
    }

    private LocaleCache() {
    }

    @Nullable
    public static Locale getLocale(@Nullable String string) {
        if (string != null && string.length() > 2) {
            String[] stringArray = StringHelper.getExplodedArray('_', string, 3);
            if (stringArray.length == 3) {
                return LocaleCache.getLocale(stringArray[0], stringArray[1], stringArray[2]);
            }
            if (stringArray.length == 2) {
                return LocaleCache.getLocale(stringArray[0], stringArray[1], "");
            }
        }
        return LocaleCache.getLocale(string, "", "");
    }

    @Nullable
    public static Locale getLocale(@Nullable String string, @Nullable String string2) {
        return LocaleCache.getLocale(string, string2, "");
    }

    @Nonnull
    private static String _buildLocaleString(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            stringBuilder.append(string);
        }
        if (string2.length() > 0) {
            stringBuilder.append('_').append(string2);
        }
        if (string3.length() > 0) {
            stringBuilder.append('_').append(string3);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Locale getLocale(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        Locale locale;
        String string4;
        String string5;
        String string6 = StringHelper.getNotNull(LocaleUtils.getValidLanguageCode(string));
        String string7 = LocaleCache._buildLocaleString(string6, string5 = StringHelper.getNotNull(LocaleUtils.getValidCountryCode(string2)), string4 = StringHelper.getNotNull(string3));
        if (string7.length() == 0) {
            return null;
        }
        s_aRWLock.readLock().lock();
        try {
            locale = s_aLocales.get(string7);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        if (locale == null) {
            s_aRWLock.writeLock().lock();
            try {
                locale = s_aLocales.get(string7);
                if (locale == null) {
                    locale = new Locale(string6, string5, string4);
                    s_aLocales.put(string7, locale);
                }
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
        return locale;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Locale> getAllLocales() {
        s_aRWLock.readLock().lock();
        try {
            Set<Locale> set = ContainerHelper.newSet(s_aLocales.values());
            set.remove(CGlobal.LOCALE_ALL);
            set.remove(CGlobal.LOCALE_INDEPENDENT);
            Set<Locale> set2 = set;
            return set2;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Locale> getAllLanguages() {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        for (Locale locale : LocaleCache.getAllLocales()) {
            String string = locale.getLanguage();
            if (!StringHelper.hasText(string)) continue;
            hashSet.add(LocaleCache.getLocale(string, null, null));
        }
        return hashSet;
    }

    public static boolean containsLocale(@Nullable String string) {
        if (string != null && string.length() > 2) {
            String[] stringArray = StringHelper.getExplodedArray('_', string, 3);
            if (stringArray.length == 3) {
                return LocaleCache.containsLocale(stringArray[0], stringArray[1], stringArray[2]);
            }
            if (stringArray.length == 2) {
                return LocaleCache.containsLocale(stringArray[0], stringArray[1], "");
            }
        }
        return LocaleCache.containsLocale(string, "", "");
    }

    public static boolean containsLocale(@Nullable String string, @Nullable String string2) {
        return LocaleCache.containsLocale(string, string2, "");
    }

    @Nonnull
    private static String _createLocaleKey(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = StringHelper.getNotNull(LocaleUtils.getValidLanguageCode(string));
        String string5 = StringHelper.getNotNull(LocaleUtils.getValidCountryCode(string2));
        String string6 = StringHelper.getNotNull(string3);
        return LocaleCache._buildLocaleString(string4, string5, string6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsLocale(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = LocaleCache._createLocaleKey(string, string2, string3);
        if (string4.length() == 0) {
            return false;
        }
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_aLocales.containsKey(string4);
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void resetCache() {
        s_aRWLock.writeLock().lock();
        try {
            s_aLocales.clear();
            LocaleCache._initialFillCache();
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Cache was reset: " + LocaleCache.class.getName());
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    static {
        LocaleCache._initialFillCache();
        s_aInstance = new LocaleCache();
    }
}

