/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.math;

import com.helger.commons.CGlobal;
import com.helger.commons.equals.EqualsUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MathHelper {
    private static final long LONG_HIGH_BITS = Integer.MIN_VALUE;
    private static final MathHelper s_aInstance = new MathHelper();

    private MathHelper() {
    }

    public static double getDividedDouble(int n, int n2) {
        double d = n;
        double d2 = n2;
        return d / d2;
    }

    @Nonnull
    public static BigDecimal getDividedBigDecimal(int n, int n2) throws ArithmeticException {
        BigDecimal bigDecimal = BigDecimal.valueOf(n);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(n2);
        return bigDecimal.divide(bigDecimal2);
    }

    public static int getIntDividedCeil(int n, int n2) {
        return MathHelper.getIntDivided(n, n2, RoundingMode.CEILING);
    }

    public static int getIntDividedFloor(int n, int n2) {
        return MathHelper.getIntDivided(n, n2, RoundingMode.FLOOR);
    }

    public static int getIntDivided(int n, int n2, @Nonnull RoundingMode roundingMode) {
        return new BigDecimal(n).divide(new BigDecimal(n2), roundingMode).intValue();
    }

    public static long getLongDividedCeil(long l, long l2) {
        return MathHelper.getLongDivided(l, l2, RoundingMode.CEILING);
    }

    public static long getLongDividedFloor(long l, long l2) {
        return MathHelper.getLongDivided(l, l2, RoundingMode.FLOOR);
    }

    public static long getLongDivided(long l, long l2, @Nonnull RoundingMode roundingMode) {
        return new BigDecimal(l).divide(new BigDecimal(l2), roundingMode).longValue();
    }

    public static boolean canConvertLongToInt(long l) {
        return (l & Integer.MIN_VALUE) == 0L || (l & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    @CheckReturnValue
    public static int getLongAsInt(long l, int n) {
        return MathHelper.canConvertLongToInt(l) ? (int)l : n;
    }

    public static int getMaxInt(int n, int ... nArray) {
        int n2 = n;
        for (int n3 : nArray) {
            n2 = Math.max(n2, n3);
        }
        return n2;
    }

    public static long getMaxLong(long l, long ... lArray) {
        long l2 = l;
        for (long l3 : lArray) {
            l2 = Math.max(l2, l3);
        }
        return l2;
    }

    public static double getMaxFloat(float f, float ... fArray) {
        float f2 = f;
        for (float f3 : fArray) {
            f2 = Math.max(f2, f3);
        }
        return f2;
    }

    public static double getMaxDouble(double d, double ... dArray) {
        double d2 = d;
        for (double d3 : dArray) {
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    @Nonnull
    public static BigDecimal getMaxBigDecimal(@Nonnull BigDecimal bigDecimal, BigDecimal ... bigDecimalArray) {
        BigDecimal bigDecimal2 = bigDecimal;
        for (BigDecimal bigDecimal3 : bigDecimalArray) {
            if (bigDecimal3.compareTo(bigDecimal2) <= 0) continue;
            bigDecimal2 = bigDecimal3;
        }
        return bigDecimal2;
    }

    @Nonnull
    public static BigInteger getMaxBigInteger(@Nonnull BigInteger bigInteger, BigInteger ... bigIntegerArray) {
        BigInteger bigInteger2 = bigInteger;
        for (BigInteger bigInteger3 : bigIntegerArray) {
            if (bigInteger3.compareTo(bigInteger2) <= 0) continue;
            bigInteger2 = bigInteger3;
        }
        return bigInteger2;
    }

    public static int getMinInt(int n, int ... nArray) {
        int n2 = n;
        for (int n3 : nArray) {
            n2 = Math.min(n2, n3);
        }
        return n2;
    }

    public static long getMinLong(long l, long ... lArray) {
        long l2 = l;
        for (long l3 : lArray) {
            l2 = Math.min(l2, l3);
        }
        return l2;
    }

    public static double getMinFloat(float f, float ... fArray) {
        float f2 = f;
        for (float f3 : fArray) {
            f2 = Math.min(f2, f3);
        }
        return f2;
    }

    public static double getMinDouble(double d, double ... dArray) {
        double d2 = d;
        for (double d3 : dArray) {
            d2 = Math.min(d2, d3);
        }
        return d2;
    }

    @Nonnull
    public static BigDecimal getMinBigDecimal(@Nonnull BigDecimal bigDecimal, BigDecimal ... bigDecimalArray) {
        BigDecimal bigDecimal2 = bigDecimal;
        for (BigDecimal bigDecimal3 : bigDecimalArray) {
            if (bigDecimal3.compareTo(bigDecimal2) >= 0) continue;
            bigDecimal2 = bigDecimal3;
        }
        return bigDecimal2;
    }

    @Nonnull
    public static BigInteger getMinBigInteger(@Nonnull BigInteger bigInteger, BigInteger ... bigIntegerArray) {
        BigInteger bigInteger2 = bigInteger;
        for (BigInteger bigInteger3 : bigIntegerArray) {
            if (bigInteger3.compareTo(bigInteger2) >= 0) continue;
            bigInteger2 = bigInteger3;
        }
        return bigInteger2;
    }

    @Nonnegative
    public static int abs(int n) {
        if (n == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("There is not absolute value for Integer.MIN_VALUE!");
        }
        return Math.abs(n);
    }

    @Nonnegative
    public static long abs(long l) {
        if (l == Long.MIN_VALUE) {
            throw new IllegalArgumentException("There is not absolute value for Long.MIN_VALUE!");
        }
        return Math.abs(l);
    }

    @Nonnegative
    public static float abs(float f) {
        return Math.abs(f);
    }

    @Nonnegative
    public static double abs(double d) {
        return Math.abs(d);
    }

    @Nonnull
    public static BigDecimal abs(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.abs();
    }

    @Nonnull
    public static BigInteger abs(@Nonnull BigInteger bigInteger) {
        return bigInteger.abs();
    }

    public static boolean isEqualToZero(@Nonnull BigDecimal bigDecimal) {
        return EqualsUtils.equals(bigDecimal, BigDecimal.ZERO);
    }

    public static boolean isNotEqualToZero(@Nonnull BigDecimal bigDecimal) {
        return !EqualsUtils.equals(bigDecimal, BigDecimal.ZERO);
    }

    public static boolean isLowerThanZero(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean isLowerOrEqualThanZero(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) <= 0;
    }

    public static boolean isGreaterThanZero(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) > 0;
    }

    public static boolean isGreaterOrEqualThanZero(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) >= 0;
    }

    public static boolean isEqualToOne(@Nonnull BigDecimal bigDecimal) {
        return EqualsUtils.equals(bigDecimal, BigDecimal.ONE);
    }

    public static boolean isNotEqualToOne(@Nonnull BigDecimal bigDecimal) {
        return !EqualsUtils.equals(bigDecimal, BigDecimal.ONE);
    }

    public static boolean isLowerThanOne(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) < 0;
    }

    public static boolean isLowerOrEqualThanOne(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) <= 0;
    }

    public static boolean isGreaterThanOne(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) > 0;
    }

    public static boolean isGreaterOrEqualThanOne(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) >= 0;
    }

    public static boolean isEqualToTen(@Nonnull BigDecimal bigDecimal) {
        return EqualsUtils.equals(bigDecimal, BigDecimal.TEN);
    }

    public static boolean isNotEqualToTen(@Nonnull BigDecimal bigDecimal) {
        return !EqualsUtils.equals(bigDecimal, BigDecimal.TEN);
    }

    public static boolean isLowerThanTen(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) < 0;
    }

    public static boolean isLowerOrEqualThanTen(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) <= 0;
    }

    public static boolean isGreaterThanTen(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) > 0;
    }

    public static boolean isGreaterOrEqualThanTen(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) >= 0;
    }

    public static boolean isEqualTo100(@Nonnull BigDecimal bigDecimal) {
        return EqualsUtils.equals(bigDecimal, CGlobal.BIGDEC_100);
    }

    public static boolean isNotEqualTo100(@Nonnull BigDecimal bigDecimal) {
        return !EqualsUtils.equals(bigDecimal, CGlobal.BIGDEC_100);
    }

    public static boolean isLowerThan100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) < 0;
    }

    public static boolean isLowerOrEqualThan100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) <= 0;
    }

    public static boolean isGreaterThan100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) > 0;
    }

    public static boolean isGreaterOrEqualThan100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) >= 0;
    }

    public static boolean isEqualToZero(@Nonnull BigInteger bigInteger) {
        return EqualsUtils.equals(bigInteger, BigInteger.ZERO);
    }

    public static boolean isNotEqualToZero(@Nonnull BigInteger bigInteger) {
        return !EqualsUtils.equals(bigInteger, BigInteger.ZERO);
    }

    public static boolean isLowerThanZero(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) < 0;
    }

    public static boolean isLowerOrEqualThanZero(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) <= 0;
    }

    public static boolean isGreaterThanZero(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) > 0;
    }

    public static boolean isGreaterOrEqualThanZero(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) >= 0;
    }

    public static boolean isEqualToOne(@Nonnull BigInteger bigInteger) {
        return EqualsUtils.equals(bigInteger, BigInteger.ONE);
    }

    public static boolean isNotEqualToOne(@Nonnull BigInteger bigInteger) {
        return !EqualsUtils.equals(bigInteger, BigInteger.ONE);
    }

    public static boolean isLowerThanOne(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) < 0;
    }

    public static boolean isLowerOrEqualThanOne(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) <= 0;
    }

    public static boolean isGreaterThanOne(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) > 0;
    }

    public static boolean isGreaterOrEqualThanOne(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) >= 0;
    }

    public static boolean isEqualToTen(@Nonnull BigInteger bigInteger) {
        return EqualsUtils.equals(bigInteger, BigInteger.TEN);
    }

    public static boolean isNotEqualToTen(@Nonnull BigInteger bigInteger) {
        return !EqualsUtils.equals(bigInteger, BigInteger.TEN);
    }

    public static boolean isLowerThanTen(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) < 0;
    }

    public static boolean isLowerOrEqualThanTen(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) <= 0;
    }

    public static boolean isGreaterThanTen(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) > 0;
    }

    public static boolean isGreaterOrEqualThanTen(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) >= 0;
    }

    public static boolean isEqualTo100(@Nonnull BigInteger bigInteger) {
        return EqualsUtils.equals(bigInteger, CGlobal.BIGINT_100);
    }

    public static boolean isNotEqualTo100(@Nonnull BigInteger bigInteger) {
        return !EqualsUtils.equals(bigInteger, CGlobal.BIGINT_100);
    }

    public static boolean isLowerThan100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) < 0;
    }

    public static boolean isLowerOrEqualThan100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) <= 0;
    }

    public static boolean isGreaterThan100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) > 0;
    }

    public static boolean isGreaterOrEqualThan100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) >= 0;
    }

    @Nullable
    @CheckReturnValue
    public static BigDecimal getWithoutTrailingZeroes(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return MathHelper.getWithoutTrailingZeroes(new BigDecimal(string));
    }

    @Nullable
    @CheckReturnValue
    public static BigDecimal getWithoutTrailingZeroes(@Nullable BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        return bigDecimal2.scale() >= 0 ? bigDecimal2 : bigDecimal2.setScale(0);
    }

    @Nonnegative
    public static int getFractionDigits(@Nonnull BigDecimal bigDecimal) {
        return MathHelper.getWithoutTrailingZeroes(bigDecimal).scale();
    }

    @Nonnull
    public static BigDecimal addPercent(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.add(bigDecimal2)).divide(CGlobal.BIGDEC_100);
    }

    @Nonnull
    public static BigDecimal subtractPercent(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.subtract(bigDecimal2)).divide(CGlobal.BIGDEC_100);
    }

    @Nonnull
    public static BigDecimal getPercentValue(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2) {
        return bigDecimal.multiply(bigDecimal2).divide(CGlobal.BIGDEC_100);
    }

    @Nonnull
    public static BigDecimal getPercentValue(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        return bigDecimal.multiply(bigDecimal2).divide(CGlobal.BIGDEC_100, n, roundingMode);
    }

    public static double hypot(double d, double d2) {
        double d3;
        double d4;
        if (d == 0.0) {
            return d2;
        }
        if (d2 == 0.0) {
            return d;
        }
        double d5 = MathHelper.abs(d);
        if (d5 > (d4 = MathHelper.abs(d2))) {
            d3 = d2 / d;
            d3 = d5 * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = d / d2;
            d3 = d4 * Math.sqrt(1.0 + d3 * d3);
        }
        return d3;
    }

    public static long getUnsignedInt(int n) {
        return (long)n & 0xFFFFFFFFL;
    }
}

