/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.convert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.ServiceLoaderUtils;
import com.helger.commons.microdom.convert.IMicroTypeConverter;
import com.helger.commons.microdom.convert.IMicroTypeConverterCallback;
import com.helger.commons.microdom.convert.IMicroTypeConverterRegistrarSPI;
import com.helger.commons.microdom.convert.IMicroTypeConverterRegistry;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MicroTypeConverterRegistry
implements IMicroTypeConverterRegistry {
    private static final MicroTypeConverterRegistry s_aInstance = new MicroTypeConverterRegistry();
    private static final Logger s_aLogger = LoggerFactory.getLogger(MicroTypeConverterRegistry.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<Class<?>, IMicroTypeConverter> s_aMap = new WeakHashMap();

    private MicroTypeConverterRegistry() {
    }

    @Nonnull
    public static MicroTypeConverterRegistry getInstance() {
        return s_aInstance;
    }

    @Override
    public void registerMicroElementTypeConverter(@Nonnull Class<?> clazz, @Nonnull IMicroTypeConverter iMicroTypeConverter) {
        MicroTypeConverterRegistry._registerMicroElementTypeConverter(clazz, iMicroTypeConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _registerMicroElementTypeConverter(@Nonnull Class<?> clazz, @Nonnull IMicroTypeConverter iMicroTypeConverter) {
        ValueEnforcer.notNull(clazz, "Class");
        ValueEnforcer.notNull(iMicroTypeConverter, "Converter");
        s_aRWLock.writeLock().lock();
        try {
            if (s_aMap.containsKey(clazz)) {
                throw new IllegalArgumentException("A micro type converter for class " + clazz + " is already registered!");
            }
            for (WeakReference<Class<?>> weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                Class clazz2 = (Class)weakReference.get();
                if (clazz2 == null || s_aMap.containsKey(clazz2)) continue;
                s_aMap.put(clazz2, iMicroTypeConverter);
                if (!s_aLogger.isDebugEnabled()) continue;
                s_aLogger.debug("Registered micro type converter for '" + clazz2.toString() + "'");
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    public static IMicroTypeConverter getConverterToMicroElement(@Nullable Class<?> clazz) {
        s_aRWLock.readLock().lock();
        try {
            IMicroTypeConverter iMicroTypeConverter = s_aMap.get(clazz);
            return iMicroTypeConverter;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IMicroTypeConverter getConverterToNative(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "DestClass");
        s_aRWLock.readLock().lock();
        try {
            IMicroTypeConverter iMicroTypeConverter = s_aMap.get(clazz);
            if (iMicroTypeConverter == null) {
                for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                    Class clazz2 = (Class)weakReference.get();
                    if (clazz2 == null || (iMicroTypeConverter = s_aMap.get(clazz2)) == null) continue;
                    if (!s_aLogger.isDebugEnabled()) break;
                    s_aLogger.debug("Using micro type converter " + iMicroTypeConverter + " for class " + clazz + " based on " + clazz2);
                    break;
                }
            }
            IMicroTypeConverter iMicroTypeConverter2 = iMicroTypeConverter;
            return iMicroTypeConverter2;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void iterateAllRegisteredMicroTypeConverters(@Nonnull IMicroTypeConverterCallback iMicroTypeConverterCallback) {
        Map<Class<?>, IMicroTypeConverter> map;
        s_aRWLock.readLock().lock();
        try {
            map = ContainerHelper.newMap(s_aMap);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        for (Map.Entry<Class<?>, IMicroTypeConverter> entry : map.entrySet()) {
            if (iMicroTypeConverterCallback.call(entry.getKey(), entry.getValue()).isBreak()) break;
        }
    }

    @Nonnegative
    public static int getRegisteredMicroTypeConverterCount() {
        s_aRWLock.readLock().lock();
        try {
            int n = s_aMap.size();
            return n;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        for (IMicroTypeConverterRegistrarSPI iMicroTypeConverterRegistrarSPI : ServiceLoaderUtils.getAllSPIImplementations(IMicroTypeConverterRegistrarSPI.class)) {
            iMicroTypeConverterRegistrarSPI.registerMicroTypeConverter(s_aInstance);
        }
        s_aLogger.info(MicroTypeConverterRegistry.getRegisteredMicroTypeConverterCount() + " micro type converters registered");
    }
}

