/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.charset.CCharset;
import com.helger.commons.codec.DecoderException;
import com.helger.commons.codec.EncoderException;
import com.helger.commons.codec.QuotedPrintableCodec;
import com.helger.commons.codec.URLCodec;
import com.helger.commons.mime.MimeTypeParser;
import java.util.BitSet;
import javax.annotation.Nonnull;

public enum EMimeQuoting {
    QUOTED_STRING{

        @Override
        @Nonnull
        @Nonempty
        public String getQuotedString(@Nonnull @Nonempty String string) {
            char[] cArray;
            StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
            stringBuilder.append('\"');
            for (char c : cArray = string.toCharArray()) {
                if (c == '\"' || c == '\\') {
                    stringBuilder.append('\\').append(c);
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.append('\"').toString();
        }

        @Override
        @Nonnull
        @Nonempty
        public String getUnquotedString(@Nonnull @Nonempty String string) {
            throw new UnsupportedOperationException("This is handled directly inside the MimeTypeParser!");
        }
    }
    ,
    QUOTED_PRINTABLE{

        @Override
        @Nonnull
        @Nonempty
        public String getQuotedString(@Nonnull @Nonempty String string) {
            return QuotedPrintableCodec.encodeText(PRINTABLE_QUOTED_PRINTABLE, string, CCharset.CHARSET_UTF_8_OBJ);
        }

        @Override
        @Nonnull
        @Nonempty
        public String getUnquotedString(@Nonnull @Nonempty String string) {
            return QuotedPrintableCodec.decodeText(string, CCharset.CHARSET_UTF_8_OBJ);
        }
    }
    ,
    URL_ESCAPE{

        @Override
        @Nonnull
        @Nonempty
        public String getQuotedString(@Nonnull @Nonempty String string) {
            return URLCodec.encodeText(PRINTABLE_URL, string, CCharset.CHARSET_UTF_8_OBJ);
        }

        @Override
        @Nonnull
        @Nonempty
        public String getUnquotedString(@Nonnull @Nonempty String string) {
            return URLCodec.decodeText(string, CCharset.CHARSET_UTF_8_OBJ);
        }
    };

    public static final char QUOTED_STRING_SEPARATOR_CHAR = '\"';
    public static final char QUOTED_STRING_MASK_CHAR = '\\';
    private static final BitSet PRINTABLE_QUOTED_PRINTABLE;
    private static final BitSet PRINTABLE_URL;

    @Nonnull
    @Nonempty
    public abstract String getQuotedString(@Nonnull @Nonempty String var1) throws EncoderException;

    @Nonnull
    @Nonempty
    public abstract String getUnquotedString(@Nonnull @Nonempty String var1) throws DecoderException;

    static {
        PRINTABLE_QUOTED_PRINTABLE = QuotedPrintableCodec.getDefaultBitSet();
        PRINTABLE_URL = URLCodec.getDefaultBitSet();
        PRINTABLE_QUOTED_PRINTABLE.set(9, false);
        PRINTABLE_QUOTED_PRINTABLE.set(32, false);
        PRINTABLE_URL.set(32, false);
        for (char c : MimeTypeParser.getAllTSpecialChars()) {
            PRINTABLE_QUOTED_PRINTABLE.set((int)c, false);
            PRINTABLE_URL.set((int)c, false);
        }
    }
}

