/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.MustImplementEqualsAndHashcode;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class MimeTypeContent {
    private final byte[] m_aContentBytes;
    private final IMimeType m_aMimeType;

    public MimeTypeContent(@Nonnull @Nonempty byte[] byArray, @Nonnull IMimeType iMimeType) {
        ValueEnforcer.notEmpty(byArray, "ContentBytes");
        ValueEnforcer.notNull(iMimeType, "MimeType");
        this.m_aContentBytes = ArrayHelper.getCopy(byArray);
        this.m_aMimeType = iMimeType;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public byte[] getContentBytes() {
        return ArrayHelper.getCopy(this.m_aContentBytes);
    }

    @Nonnegative
    public int getContentByteCount() {
        return this.m_aContentBytes.length;
    }

    public void writeContentBytes(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        outputStream.write(this.m_aContentBytes, 0, this.m_aContentBytes.length);
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    private static boolean _match(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnull byte[] byArray2) {
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean matchesBeginning(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Bytes");
        return byArray.length >= this.m_aContentBytes.length && MimeTypeContent._match(byArray, 0, this.m_aContentBytes);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MimeTypeContent mimeTypeContent = (MimeTypeContent)object;
        return Arrays.equals(this.m_aContentBytes, mimeTypeContent.m_aContentBytes) && this.m_aMimeType.equals(mimeTypeContent.m_aMimeType);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aContentBytes).append(this.m_aMimeType).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("contentBytes", Arrays.toString(this.m_aContentBytes)).append("mimeType", this.m_aMimeType).toString();
    }
}

