/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.GlobalDebug;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.MustBeLocked;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.charset.EUnicodeBOM;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.exceptions.InitializationException;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.microdom.reader.XMLMapHandler;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeContent;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MimeTypeDeterminator {
    public static final IMimeType DEFAULT_MIME_TYPE = CMimeType.APPLICATION_OCTET_STREAM;
    private static final Logger s_aLogger = LoggerFactory.getLogger(MimeTypeDeterminator.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<String, String> s_aFileExtMap = new HashMap<String, String>();
    private static final Set<MimeTypeContent> s_aMimeTypeContents = new HashSet<MimeTypeContent>();
    private static final byte[] MIME_ID_GIF87A = new byte[]{71, 73, 70, 56, 55, 97};
    private static final byte[] MIME_ID_GIF89A = new byte[]{71, 73, 70, 56, 57, 97};
    private static final byte[] MIME_ID_JPG = new byte[]{-1, -40};
    private static final byte[] MIME_ID_PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] MIME_ID_TIFF_MOTOROLLA = new byte[]{77, 77};
    private static final byte[] MIME_ID_TIFF_INTEL = new byte[]{73, 73};
    private static final byte[] MIME_ID_PSD = new byte[]{56, 66, 80, 83};
    private static final byte[] MIME_ID_PDF = new byte[]{37, 80, 68, 70};
    private static final byte[] MIME_ID_XLS = new byte[]{-48, -51, 17, -32};
    private static final MimeTypeDeterminator s_aInstance;

    @MustBeLocked(value=MustBeLocked.ELockType.WRITE)
    private static void _registerDefaultMimeTypeContents() {
        s_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_GIF87A, CMimeType.IMAGE_GIF));
        s_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_GIF89A, CMimeType.IMAGE_GIF));
        s_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_JPG, CMimeType.IMAGE_JPG));
        s_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_PNG, CMimeType.IMAGE_PNG));
        s_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_TIFF_MOTOROLLA, CMimeType.IMAGE_TIFF));
        s_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_TIFF_INTEL, CMimeType.IMAGE_TIFF));
        s_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_PSD, CMimeType.IMAGE_PSD));
        s_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_PDF, CMimeType.APPLICATION_PDF));
        s_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_XLS, CMimeType.APPLICATION_MS_EXCEL));
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(new byte[]{60, 0, 0, 0, 63, 0, 0, 0});
        arrayList.add(new byte[]{0, 60, 0, 0, 0, 63, 0, 0});
        arrayList.add(new byte[]{0, 0, 60, 0, 0, 0, 63, 0});
        arrayList.add(new byte[]{0, 0, 0, 60, 0, 0, 0, 63});
        arrayList.add(new byte[]{0, 60, 0, 63});
        arrayList.add(new byte[]{60, 0, 63, 0});
        arrayList.add(new byte[]{60, 63, 120, 109});
        arrayList.add(new byte[]{76, 111, -89, -108});
        for (byte[] byArray : arrayList) {
            MimeTypeDeterminator.registerMimeTypeContent(new MimeTypeContent(byArray, CMimeType.TEXT_XML));
        }
        for (EUnicodeBOM eUnicodeBOM : EUnicodeBOM.values()) {
            for (byte[] byArray : arrayList) {
                byte[] byArray2 = ArrayHelper.getConcatenated(eUnicodeBOM.getBytes(), byArray);
                MimeTypeDeterminator.registerMimeTypeContent(new MimeTypeContent(byArray2, CMimeType.TEXT_XML));
            }
        }
    }

    private MimeTypeDeterminator() {
    }

    @Nonnull
    public static EChange registerMimeTypeContent(@Nonnull MimeTypeContent mimeTypeContent) {
        ValueEnforcer.notNull(mimeTypeContent, "MimeTypeContent");
        s_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(s_aMimeTypeContents.add(mimeTypeContent));
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    public static EChange unregisterMimeTypeContent(@Nullable MimeTypeContent mimeTypeContent) {
        if (mimeTypeContent == null) {
            return EChange.UNCHANGED;
        }
        s_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(s_aMimeTypeContents.remove(mimeTypeContent));
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    @Deprecated
    public static IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull @Nonempty String string2) {
        return MimeTypeDeterminator.getMimeTypeFromBytes(string == null ? null : CharsetManager.getAsBytes(string, string2));
    }

    @Nonnull
    public static IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull Charset charset) {
        return MimeTypeDeterminator.getMimeTypeFromString(string, charset, DEFAULT_MIME_TYPE);
    }

    @Nullable
    public static IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull Charset charset, @Nullable IMimeType iMimeType) {
        return MimeTypeDeterminator.getMimeTypeFromBytes(string == null ? null : CharsetManager.getAsBytes(string, charset), iMimeType);
    }

    @Nonnull
    public static IMimeType getMimeTypeFromBytes(@Nullable byte[] byArray) {
        return MimeTypeDeterminator.getMimeTypeFromBytes(byArray, DEFAULT_MIME_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IMimeType getMimeTypeFromBytes(@Nullable byte[] byArray, @Nullable IMimeType iMimeType) {
        if (byArray != null && byArray.length > 0) {
            s_aRWLock.readLock().lock();
            try {
                for (MimeTypeContent mimeTypeContent : s_aMimeTypeContents) {
                    if (!mimeTypeContent.matchesBeginning(byArray)) continue;
                    IMimeType iMimeType2 = mimeTypeContent.getMimeType();
                    return iMimeType2;
                }
            }
            finally {
                s_aRWLock.readLock().unlock();
            }
        }
        return iMimeType;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<MimeTypeContent> getAllMimeTypeContents() {
        s_aRWLock.readLock().lock();
        try {
            List<MimeTypeContent> list = ContainerHelper.newList(s_aMimeTypeContents);
            return list;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    @Nullable
    @Deprecated
    public static String getMimeTypeFromFilename(@Nullable String string) {
        String string2 = FilenameHelper.getExtension(string);
        return MimeTypeDeterminator.getMimeTypeFromExtension(string2);
    }

    @Nullable
    @Deprecated
    public static MimeType getMimeTypeObjectFromFilename(@Nonnull String string) {
        String string2 = MimeTypeDeterminator.getMimeTypeFromFilename(string);
        return MimeTypeParser.parseMimeType(string2);
    }

    @Nullable
    @Deprecated
    public static String getMimeTypeFromExtension(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        String string2 = s_aFileExtMap.get(string);
        if (string2 == null) {
            string2 = s_aFileExtMap.get(string.toLowerCase(Locale.US));
        }
        return string2;
    }

    @Nullable
    @Deprecated
    public static MimeType getMimeTypeObjectFromExtension(@Nullable String string) {
        String string2 = MimeTypeDeterminator.getMimeTypeFromExtension(string);
        return MimeTypeParser.parseMimeType(string2);
    }

    @Nonnull
    @Deprecated
    @ReturnsMutableCopy
    public static Collection<String> getAllKnownMimeTypes() {
        return ContainerHelper.newList(s_aFileExtMap.values());
    }

    @Nonnull
    @Deprecated
    @ReturnsMutableCopy
    public static Map<String, String> getAllKnownMimeTypeFilenameMappings() {
        return ContainerHelper.newMap(s_aFileExtMap);
    }

    public static void resetCache() {
        s_aRWLock.writeLock().lock();
        try {
            s_aMimeTypeContents.clear();
            MimeTypeDeterminator._registerDefaultMimeTypeContents();
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Cache was reset: " + MimeTypeDeterminator.class.getName());
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    static {
        if (XMLMapHandler.readMap(new ClassPathResource("codelists/fileext-mimetype-mapping.xml"), s_aFileExtMap).isFailure()) {
            throw new InitializationException("Failed to init file extension to mimetype mapping file");
        }
        if (GlobalDebug.isDebugMode()) {
            for (Map.Entry<String, String> entry : s_aFileExtMap.entrySet()) {
                String string = entry.getKey();
                if (!RegExHelper.stringMatchesPattern("(|[a-zA-Z0-9]+(\\.[a-z0-9]+)*)", string)) {
                    throw new InitializationException("MIME file extension '" + string + "' is invalid!");
                }
                if (!entry.getValue().contains(" ")) continue;
                throw new InitializationException("MIME type '" + entry.getValue() + "' is invalid!");
            }
        }
        MimeTypeDeterminator._registerDefaultMimeTypeContents();
        s_aInstance = new MimeTypeDeterminator();
    }
}

