/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.callback.IChangeNotify;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IMultiLingualText;
import com.helger.commons.text.IReadonlyMultiLingualText;
import com.helger.commons.text.ISimpleMultiLingualText;
import com.helger.commons.text.impl.MultiLingualText;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MultiLingualTextThreadSafe
implements IMultiLingualText {
    protected final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final MultiLingualText m_aMLT;

    public MultiLingualTextThreadSafe() {
        this.m_aMLT = new MultiLingualText();
    }

    public MultiLingualTextThreadSafe(@Nonnull ISimpleMultiLingualText iSimpleMultiLingualText) {
        ValueEnforcer.notNull(iSimpleMultiLingualText, "SimpleMLT");
        this.m_aMLT = new MultiLingualText(iSimpleMultiLingualText);
    }

    public MultiLingualTextThreadSafe(@Nonnull IReadonlyMultiLingualText iReadonlyMultiLingualText) {
        ValueEnforcer.notNull(iReadonlyMultiLingualText, "MLT");
        this.m_aMLT = new MultiLingualText(iReadonlyMultiLingualText);
    }

    @Override
    @Nullable
    public String getText(@Nonnull Locale locale) {
        this.m_aRWLock.readLock().lock();
        try {
            String string = this.m_aMLT.getText(locale);
            return string;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nullable
    public String getTextWithLocaleFallback(@Nonnull Locale locale) {
        this.m_aRWLock.readLock().lock();
        try {
            String string = this.m_aMLT.getTextWithLocaleFallback(locale);
            return string;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getTextWithArgs(@Nonnull Locale locale, Object ... objectArray) {
        this.m_aRWLock.readLock().lock();
        try {
            String string = this.m_aMLT.getTextWithArgs(locale, objectArray);
            return string;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getTextWithLocaleFallbackAndArgs(@Nonnull Locale locale, Object ... objectArray) {
        this.m_aRWLock.readLock().lock();
        try {
            String string = this.m_aMLT.getTextWithLocaleFallbackAndArgs(locale, objectArray);
            return string;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange addText(@Nonnull Locale locale, @Nullable String string) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aMLT.addText(locale, string);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange setText(@Nonnull Locale locale, @Nullable String string) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aMLT.setText(locale, string);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    @Nonnegative
    public int getLocaleCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aMLT.getLocaleCount();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    public boolean containsLocale(@Nullable Locale locale) {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_aMLT.containsLocale(locale);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    public boolean containsLocaleWithFallback(@Nullable Locale locale) {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_aMLT.containsLocaleWithFallback(locale);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<Locale, String> getMap() {
        this.m_aRWLock.readLock().lock();
        try {
            Map<Locale, String> map = ContainerHelper.newMap(this.m_aMLT.internalGetMap());
            return map;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnegative
    public int size() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aMLT.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_aMLT.isEmpty();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<Locale> getAllLocales() {
        this.m_aRWLock.readLock().lock();
        try {
            Set<Locale> set = ContainerHelper.newSet(this.m_aMLT.internalGetAllLocales());
            return set;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    public EChange removeText(@Nonnull Locale locale) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aMLT.removeText(locale);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    @Nonnull
    public EChange clear() {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aMLT.clear();
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    @Nonnull
    public EChange assignFrom(@Nonnull IReadonlyMultiLingualText iReadonlyMultiLingualText) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aMLT.assignFrom(iReadonlyMultiLingualText);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    public void addChangeNotifier(@Nonnull IChangeNotify<IMultiLingualText> iChangeNotify) {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMLT.addChangeNotifier(iChangeNotify);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MultiLingualTextThreadSafe multiLingualTextThreadSafe = (MultiLingualTextThreadSafe)object;
        return this.m_aMLT.equals(multiLingualTextThreadSafe.m_aMLT);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aMLT).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("mlt", this.m_aMLT).toString();
    }

    @Nonnull
    public static IMultiLingualText createFromMap(@Nonnull Map<String, String> map) {
        MultiLingualTextThreadSafe multiLingualTextThreadSafe = new MultiLingualTextThreadSafe();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getValue();
            if (string == null) continue;
            multiLingualTextThreadSafe.setText(LocaleCache.getLocale(entry.getKey()), string);
        }
        return multiLingualTextThreadSafe;
    }
}

