/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert;

import com.helger.commons.GlobalDebug;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.collections.multimap.IMultiMapListBased;
import com.helger.commons.collections.multimap.MultiTreeMapArrayListBased;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.ServiceLoaderUtils;
import com.helger.commons.mutable.Wrapper;
import com.helger.commons.state.EContinue;
import com.helger.commons.typeconvert.ITypeConverter;
import com.helger.commons.typeconvert.ITypeConverterCallback;
import com.helger.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.commons.typeconvert.ITypeConverterRegistry;
import com.helger.commons.typeconvert.ITypeConverterRule;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class TypeConverterRegistry
implements ITypeConverterRegistry {
    private static final TypeConverterRegistry s_aInstance = new TypeConverterRegistry();
    private static final Logger s_aLogger = LoggerFactory.getLogger(TypeConverterRegistry.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final Map<Class<?>, Map<Class<?>, ITypeConverter>> s_aConverter = new WeakHashMap();
    @GuardedBy(value="s_aRWLock")
    private static final IMultiMapListBased<ITypeConverterRule.ESubType, ITypeConverterRule> s_aRules = new MultiTreeMapArrayListBased<ITypeConverterRule.ESubType, ITypeConverterRule>();

    private TypeConverterRegistry() {
    }

    @Nonnull
    private static Map<Class<?>, ITypeConverter> _getOrCreateConverterMap(@Nonnull Class<?> clazz) {
        Map<Class<?>, ITypeConverter> map;
        s_aRWLock.readLock().lock();
        try {
            map = s_aConverter.get(clazz);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        if (map == null) {
            s_aRWLock.writeLock().lock();
            try {
                map = s_aConverter.get(clazz);
                if (map == null) {
                    map = new WeakHashMap();
                    s_aConverter.put(clazz, map);
                }
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _registerTypeConverter(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2, @Nonnull ITypeConverter iTypeConverter) {
        Map<Class<?>, ITypeConverter> map;
        ValueEnforcer.notNull(clazz, "SrcClass");
        if (!ClassHelper.isPublic(clazz)) {
            throw new IllegalArgumentException("Source " + clazz + " is no public class!");
        }
        ValueEnforcer.notNull(clazz2, "DstClass");
        if (!ClassHelper.isPublic(clazz2)) {
            throw new IllegalArgumentException("Destination " + clazz2 + " is no public class!");
        }
        if (clazz.equals(clazz2)) {
            throw new IllegalArgumentException("Source and destination class are equal and therefore no converter is required.");
        }
        ValueEnforcer.notNull(iTypeConverter, "Converter");
        if (iTypeConverter instanceof ITypeConverterRule) {
            throw new IllegalArgumentException("Type converter rules must be registered via registerTypeConverterRule");
        }
        if (ClassHelper.areConvertibleClasses(clazz, clazz2)) {
            s_aLogger.warn("No type converter needed between " + clazz + " and " + clazz2 + " because types are convertible!");
        }
        if ((map = TypeConverterRegistry._getOrCreateConverterMap(clazz)).containsKey(clazz2)) {
            throw new IllegalArgumentException("A mapping from " + clazz + " to " + clazz2 + " is already defined!");
        }
        s_aRWLock.writeLock().lock();
        try {
            for (WeakReference<Class<?>> weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz2)) {
                Class clazz3 = (Class)weakReference.get();
                if (clazz3 == null || map.containsKey(clazz3)) continue;
                if (map.put(clazz3, iTypeConverter) != null) {
                    s_aLogger.warn("Overwriting converter from " + clazz + " to " + clazz3);
                    continue;
                }
                if (!s_aLogger.isDebugEnabled()) continue;
                s_aLogger.debug("Registered type converter from '" + clazz.toString() + "' to '" + clazz3.toString() + "'");
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Override
    public void registerTypeConverter(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2, @Nonnull ITypeConverter iTypeConverter) {
        TypeConverterRegistry._registerTypeConverter(clazz, clazz2, iTypeConverter);
    }

    @Override
    public void registerTypeConverter(@Nonnull Class<?>[] classArray, @Nonnull Class<?> clazz, @Nonnull ITypeConverter iTypeConverter) {
        for (Class<?> clazz2 : classArray) {
            TypeConverterRegistry._registerTypeConverter(clazz2, clazz, iTypeConverter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static ITypeConverter getExactConverter(@Nullable Class<?> clazz, @Nullable Class<?> clazz2) {
        s_aRWLock.readLock().lock();
        try {
            Map<Class<?>, ITypeConverter> map = s_aConverter.get(clazz);
            ITypeConverter iTypeConverter = map == null ? null : map.get(clazz2);
            return iTypeConverter;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static ITypeConverter getRuleBasedConverter(@Nullable Class<?> clazz, @Nullable Class<?> clazz2) {
        if (clazz == null || clazz2 == null) {
            return null;
        }
        s_aRWLock.readLock().lock();
        try {
            for (Map.Entry entry : s_aRules.entrySet()) {
                for (ITypeConverterRule iTypeConverterRule : (List)entry.getValue()) {
                    if (!iTypeConverterRule.canConvert(clazz, clazz2)) continue;
                    ITypeConverterRule iTypeConverterRule2 = iTypeConverterRule;
                    return iTypeConverterRule2;
                }
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    private static void _iterateFuzzyConverters(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2, @Nonnull ITypeConverterCallback iTypeConverterCallback) {
        ITypeConverter iTypeConverter;
        Map<Class<?>, ITypeConverter> map;
        WeakReference<Class<?>> weakReference;
        Class clazz3;
        Iterator<WeakReference<Class<?>>> iterator = ClassHierarchyCache.getClassHierarchyIterator(clazz).iterator();
        while (iterator.hasNext() && ((clazz3 = (Class)(weakReference = iterator.next()).get()) == null || (map = s_aConverter.get(clazz3)) == null || (iTypeConverter = map.get(clazz2)) == null || !iTypeConverterCallback.call(clazz3, clazz2, iTypeConverter).isBreak())) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static ITypeConverter getFuzzyConverter(final @Nullable Class<?> clazz, final @Nullable Class<?> clazz2) {
        if (clazz == null || clazz2 == null) {
            return null;
        }
        s_aRWLock.readLock().lock();
        try {
            Object object;
            if (GlobalDebug.isDebugMode()) {
                object = new ArrayList();
                TypeConverterRegistry._iterateFuzzyConverters(clazz, clazz2, new ITypeConverterCallback((List)object){
                    final /* synthetic */ List val$aAllConverters;
                    {
                        this.val$aAllConverters = list;
                    }

                    @Override
                    @Nonnull
                    public EContinue call(@Nonnull Class<?> clazz3, @Nonnull Class<?> clazz22, @Nonnull ITypeConverter iTypeConverter) {
                        boolean bl = clazz.equals(clazz3) && clazz2.equals(clazz22);
                        this.val$aAllConverters.add("[" + clazz3.getName() + "->" + clazz22.getName() + "]");
                        return bl ? EContinue.BREAK : EContinue.CONTINUE;
                    }
                });
                if (object.size() > 1) {
                    s_aLogger.warn("The fuzzy type converter resolver returned more than 1 match for the conversion from " + clazz + " to " + clazz2 + ": " + object);
                }
            }
            object = new Wrapper();
            TypeConverterRegistry._iterateFuzzyConverters(clazz, clazz2, new ITypeConverterCallback((Wrapper)object){
                final /* synthetic */ Wrapper val$ret;
                {
                    this.val$ret = wrapper;
                }

                @Override
                @Nonnull
                public EContinue call(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2, @Nonnull ITypeConverter iTypeConverter) {
                    this.val$ret.set(iTypeConverter);
                    return EContinue.BREAK;
                }
            });
            ITypeConverter iTypeConverter = (ITypeConverter)((Wrapper)object).get();
            return iTypeConverter;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static void iterateAllRegisteredTypeConverters(@Nonnull ITypeConverterCallback iTypeConverterCallback) {
        Map<Class<?>, Map<Class<?>, ITypeConverter>> map;
        s_aRWLock.readLock().lock();
        try {
            map = ContainerHelper.newMap(s_aConverter);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        block3: for (Map.Entry<Class<?>, Map<Class<?>, ITypeConverter>> entry : map.entrySet()) {
            Class<?> clazz = entry.getKey();
            for (Map.Entry<Class<?>, ITypeConverter> entry2 : entry.getValue().entrySet()) {
                if (!iTypeConverterCallback.call(clazz, entry2.getKey(), entry2.getValue()).isBreak()) continue;
                break block3;
            }
        }
    }

    @Nonnegative
    public static int getRegisteredTypeConverterCount() {
        s_aRWLock.readLock().lock();
        try {
            int n = 0;
            for (Map<Class<?>, ITypeConverter> map : s_aConverter.values()) {
                n += map.size();
            }
            int n2 = n;
            return n2;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    @Override
    public void registerTypeConverterRule(@Nonnull ITypeConverterRule iTypeConverterRule) {
        ValueEnforcer.notNull(iTypeConverterRule, "TypeConverterRule");
        s_aRWLock.writeLock().lock();
        try {
            s_aRules.putSingle(iTypeConverterRule.getSubType(), iTypeConverterRule);
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nonnegative
    public static long getRegisteredTypeConverterRuleCount() {
        s_aRWLock.readLock().lock();
        try {
            long l = s_aRules.getTotalValueCount();
            return l;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        for (ITypeConverterRegistrarSPI iTypeConverterRegistrarSPI : ServiceLoaderUtils.getAllSPIImplementations(ITypeConverterRegistrarSPI.class)) {
            iTypeConverterRegistrarSPI.registerTypeConverter(s_aInstance);
        }
        s_aLogger.info(TypeConverterRegistry.getRegisteredTypeConverterCount() + " type converters and " + TypeConverterRegistry.getRegisteredTypeConverterRuleCount() + " rules registered");
    }
}

