/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.version;

import com.helger.commons.IHasStringRepresentation;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.version.Version;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class VersionRange
implements Comparable<VersionRange>,
IHasStringRepresentation,
Serializable {
    public static final String DEFAULT_VERSION_RANGE_STRING = "[0)";
    private final boolean m_bIncludeFloor;
    private final Version m_aFloorVersion;
    private final boolean m_bIncludeCeil;
    private final Version m_aCeilVersion;

    public VersionRange(@Nullable String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.length() == 0) {
            this.m_bIncludeFloor = true;
            this.m_aFloorVersion = new Version("0");
            this.m_bIncludeCeil = false;
            this.m_aCeilVersion = null;
        } else {
            int n = 0;
            if (string2.charAt(n) == '[') {
                this.m_bIncludeFloor = true;
                ++n;
            } else if (string2.charAt(n) == '(') {
                this.m_bIncludeFloor = false;
                ++n;
            } else {
                this.m_bIncludeFloor = true;
            }
            int n2 = 0;
            if (StringHelper.endsWith((CharSequence)string2, ']')) {
                this.m_bIncludeCeil = true;
                ++n2;
            } else if (StringHelper.endsWith((CharSequence)string2, ')')) {
                this.m_bIncludeCeil = false;
                ++n2;
            } else {
                this.m_bIncludeCeil = false;
            }
            int n3 = string2.length() - n - n2;
            if (n3 == 0) {
                this.m_aFloorVersion = new Version("0");
                this.m_aCeilVersion = null;
            } else {
                String[] stringArray = StringHelper.getExplodedArray(',', string2.substring(n, string2.length() - n2));
                String string4 = stringArray[0].trim();
                String string5 = stringArray.length > 1 ? stringArray[1].trim() : null;
                this.m_aFloorVersion = new Version(string4);
                this.m_aCeilVersion = StringHelper.hasNoText(string5) ? null : new Version(string5);
            }
        }
        if (this.m_aCeilVersion != null && this.m_aFloorVersion.compareTo(this.m_aCeilVersion) > 0) {
            throw new IllegalArgumentException("Floor version may not be greater than the ceiling version!");
        }
    }

    public VersionRange(@Nonnull Version version, @Nullable Version version2) {
        this(version, true, version2, true);
    }

    public VersionRange(@Nonnull Version version, boolean bl, @Nullable Version version2, boolean bl2) {
        ValueEnforcer.notNull(version, "FloorVersion");
        this.m_aFloorVersion = version;
        this.m_bIncludeFloor = bl;
        this.m_aCeilVersion = version2;
        this.m_bIncludeCeil = bl2;
        if (this.m_aCeilVersion != null && this.m_aFloorVersion.compareTo(this.m_aCeilVersion) > 0) {
            throw new IllegalArgumentException("Floor version may not be greater than the ceiling version!");
        }
    }

    public boolean isIncludingFloor() {
        return this.m_bIncludeFloor;
    }

    @Nullable
    public Version getFloorVersion() {
        return this.m_aFloorVersion;
    }

    public boolean isIncludingCeil() {
        return this.m_bIncludeCeil;
    }

    @Nullable
    public Version getCeilVersion() {
        return this.m_aCeilVersion;
    }

    public boolean versionMatches(@Nonnull Version version) {
        int n = this.m_aFloorVersion.compareTo(version);
        if (this.m_bIncludeFloor ? n > 0 : n >= 0) {
            return false;
        }
        if (this.m_aCeilVersion != null) {
            n = this.m_aCeilVersion.compareTo(version);
            if (this.m_bIncludeCeil ? n < 0 : n <= 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(@Nonnull VersionRange versionRange) {
        int n = this.m_aFloorVersion.compareTo(versionRange.m_aFloorVersion);
        if (n == 0) {
            if (this.m_bIncludeFloor && !versionRange.m_bIncludeFloor) {
                n = -1;
            } else if (!this.m_bIncludeFloor && versionRange.m_bIncludeFloor) {
                n = 1;
            }
            if (n == 0) {
                if (this.m_aCeilVersion != null && versionRange.m_aCeilVersion == null) {
                    n = -1;
                } else if (this.m_aCeilVersion == null && versionRange.m_aCeilVersion != null) {
                    n = 1;
                } else if (this.m_aCeilVersion != null && versionRange.m_aCeilVersion != null) {
                    n = this.m_aCeilVersion.compareTo(versionRange.m_aCeilVersion);
                }
                if (n == 0) {
                    if (this.m_bIncludeCeil && !versionRange.m_bIncludeCeil) {
                        n = 1;
                    } else if (!this.m_bIncludeCeil && versionRange.m_bIncludeCeil) {
                        n = -1;
                    }
                }
            }
        }
        return n;
    }

    @Override
    @Nonnull
    public String getAsString() {
        return this.getAsString(false);
    }

    @Nonnull
    public String getAsString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(this.m_bIncludeFloor ? "[" : "(");
        stringBuilder.append(this.m_aFloorVersion.getAsString(bl));
        if (this.m_aCeilVersion != null) {
            stringBuilder.append(',').append(this.m_aCeilVersion.getAsString(bl));
        }
        return stringBuilder.append(this.m_bIncludeCeil ? (char)']' : ')').toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VersionRange)) {
            return false;
        }
        VersionRange versionRange = (VersionRange)object;
        return this.m_bIncludeFloor == versionRange.m_bIncludeFloor && this.m_aFloorVersion.equals(versionRange.m_aFloorVersion) && this.m_bIncludeCeil == versionRange.m_bIncludeCeil && EqualsUtils.equals(this.m_aCeilVersion, versionRange.m_aCeilVersion);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFloorVersion).append(this.m_bIncludeFloor).append(this.m_aCeilVersion).append(this.m_bIncludeCeil).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("floorVersion", this.m_aFloorVersion).append("inclFloor", this.m_bIncludeFloor).append("ceilVersion", this.m_aCeilVersion).append("inclCeil", this.m_bIncludeCeil).toString();
    }
}

