/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;

@NotThreadSafe
public class MapBasedXPathVariableResolver
implements XPathVariableResolver {
    private final Map<String, Object> m_aVars;

    public MapBasedXPathVariableResolver() {
        this(null);
    }

    public MapBasedXPathVariableResolver(@Nullable Map<String, ?> map) {
        this.m_aVars = ContainerHelper.newMap(map);
    }

    @Nonnull
    public EChange addUniqueVariable(@Nonnull String string, @Nonnull Object object) {
        ValueEnforcer.notNull(string, "Name");
        ValueEnforcer.notNull(object, "Value");
        if (this.m_aVars.containsKey(string)) {
            return EChange.UNCHANGED;
        }
        this.m_aVars.put(string, object);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeVariable(@Nullable String string) {
        return EChange.valueOf(this.m_aVars.remove(string) != null);
    }

    @Nonnull
    public EChange removeVariables(@Nullable Iterable<String> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (String string : iterable) {
                eChange = eChange.or(this.removeVariable(string));
            }
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Map<String, ?> getAllVariables() {
        return ContainerHelper.newMap(this.m_aVars);
    }

    @Nonnegative
    public int getVariableCount() {
        return this.m_aVars.size();
    }

    @Nonnull
    public EChange clear() {
        if (this.m_aVars.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aVars.clear();
        return EChange.CHANGED;
    }

    public void setAllVariables(@Nullable Map<String, ?> map) {
        this.m_aVars.clear();
        if (map != null) {
            this.m_aVars.putAll(map);
        }
    }

    @Override
    @Nullable
    public Object resolveVariable(@Nonnull QName qName) {
        ValueEnforcer.notNull(qName, "VariableName");
        if (this.m_aVars == null) {
            return null;
        }
        String string = qName.getLocalPart();
        return this.m_aVars.get(string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedXPathVariableResolver mapBasedXPathVariableResolver = (MapBasedXPathVariableResolver)object;
        return EqualsUtils.equals(this.m_aVars, mapBasedXPathVariableResolver.m_aVars);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aVars)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("vars", this.m_aVars).toString();
    }
}

