/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.charset.CCharset;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.codec.AbstractCodec;
import com.helger.commons.codec.DecoderException;
import com.helger.commons.codec.IStringCodec;
import com.helger.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.string.StringHelper;
import java.nio.charset.Charset;
import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QuotedPrintableCodec
extends AbstractCodec
implements IStringCodec {
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;
    private static final BitSet PRINTABLE_CHARS = new BitSet(256);
    private final Charset m_aCharset;

    public QuotedPrintableCodec() {
        this(CCharset.CHARSET_UTF_8_OBJ);
    }

    public QuotedPrintableCodec(@Nonnull Charset charset) {
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    @Override
    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static BitSet getDefaultBitSet() {
        return (BitSet)PRINTABLE_CHARS.clone();
    }

    public static final void encodeQuotedPrintable(int n, @Nonnull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream) {
        char c = Character.toUpperCase(StringHelper.getHexChar(n >> 4 & 0xF));
        char c2 = Character.toUpperCase(StringHelper.getHexChar(n & 0xF));
        nonBlockingByteArrayOutputStream.write(61);
        nonBlockingByteArrayOutputStream.write(c);
        nonBlockingByteArrayOutputStream.write(c2);
    }

    @Nonnull
    public static byte[] encodeQuotedPrintable(@Nonnull BitSet bitSet, @Nonnull byte[] byArray) {
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(byArray.length * 2);
        for (byte by : byArray) {
            int n = by & 0xFF;
            if (bitSet.get(n)) {
                nonBlockingByteArrayOutputStream.write(n);
                continue;
            }
            QuotedPrintableCodec.encodeQuotedPrintable(n, nonBlockingByteArrayOutputStream);
        }
        return nonBlockingByteArrayOutputStream.toByteArray();
    }

    @Override
    @Nullable
    public byte[] encode(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static byte[] decodeQuotedPrintable(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        try {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte by = byArray[i];
                if (by == 61) {
                    char c;
                    int n2;
                    if (i >= n - 2) {
                        throw new DecoderException("Invalid quoted-printable encoding. Premature of string after escape char");
                    }
                    ++i;
                    char c2 = (char)byArray[i];
                    if ((n2 = StringHelper.getHexByte(c2, c = (char)byArray[++i])) < 0) {
                        throw new DecoderException("Invalid quoted-printable encoding for " + c2 + c);
                    }
                    nonBlockingByteArrayOutputStream.write(n2);
                    continue;
                }
                nonBlockingByteArrayOutputStream.write(by);
            }
            byte[] byArray2 = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            StreamUtils.close(nonBlockingByteArrayOutputStream);
        }
    }

    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] byArray) {
        return QuotedPrintableCodec.decodeQuotedPrintable(byArray);
    }

    @Override
    @Nullable
    public String encodeText(@Nullable String string) {
        return QuotedPrintableCodec.encodeText(string, this.m_aCharset);
    }

    @Nullable
    public String encodeText(@Nonnull BitSet bitSet, @Nullable String string) {
        return QuotedPrintableCodec.encodeText(bitSet, string, this.m_aCharset);
    }

    @Nullable
    public static String encodeText(@Nullable String string, @Nonnull Charset charset) {
        return QuotedPrintableCodec.encodeText(PRINTABLE_CHARS, string, charset);
    }

    @Nullable
    public static String encodeText(@Nonnull BitSet bitSet, @Nullable String string, @Nonnull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = QuotedPrintableCodec.encodeQuotedPrintable(bitSet, CharsetManager.getAsBytes(string, charset));
        return CharsetManager.getAsString(byArray, CCharset.CHARSET_US_ASCII_OBJ);
    }

    @Override
    @Nullable
    public String decodeText(@Nullable String string) {
        return QuotedPrintableCodec.decodeText(string, this.m_aCharset);
    }

    @Nullable
    public static String decodeText(@Nullable String string, @Nonnull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = CharsetManager.getAsBytes(string, CCharset.CHARSET_US_ASCII_OBJ);
        byArray = QuotedPrintableCodec.decodeQuotedPrintable(byArray);
        return CharsetManager.getAsString(byArray, charset);
    }

    static {
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
        for (int i = 33; i <= 126; ++i) {
            if (i == 61) continue;
            PRINTABLE_CHARS.set(i);
        }
    }
}

