/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ArrayIteratorLong {
    private final long[] m_aArray;
    private int m_nIndex;

    public ArrayIteratorLong(long ... lArray) {
        ValueEnforcer.notNull(lArray, "Array");
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy(lArray);
    }

    private ArrayIteratorLong(@Nonnull long[] lArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(lArray, n, n2);
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy(lArray, n, n2);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    @Deprecated
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayIteratorLong)) {
            return false;
        }
        ArrayIteratorLong arrayIteratorLong = (ArrayIteratorLong)object;
        return EqualsUtils.equals(this.m_aArray, arrayIteratorLong.m_aArray) && this.m_nIndex == arrayIteratorLong.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).toString();
    }

    @Nonnull
    public static ArrayIteratorLong createOfsLen(@Nonnull long[] lArray, @Nonnegative int n, @Nonnegative int n2) {
        return new ArrayIteratorLong(lArray, n, n2);
    }

    @Nonnull
    public static ArrayIteratorLong createBeginEnd(@Nonnull long[] lArray, @Nonnegative int n, @Nonnegative int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Begin (" + n + ") must be between 0 and < end (" + n2 + ")");
        }
        return ArrayIteratorLong.createOfsLen(lArray, n, n2 - n);
    }
}

