/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.iterate;

import com.helger.commons.collections.iterate.EmptyEnumeration;
import com.helger.commons.string.ToStringGenerator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CombinedEnumeration<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private final Enumeration<? extends ELEMENTTYPE> m_aEnum1;
    private final Enumeration<? extends ELEMENTTYPE> m_aEnum2;
    private boolean m_bFirstEnum;

    public CombinedEnumeration(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration, @Nullable Enumeration<? extends ELEMENTTYPE> enumeration2) {
        this.m_aEnum1 = enumeration;
        this.m_aEnum2 = enumeration2;
        this.m_bFirstEnum = enumeration != null;
    }

    @Override
    public boolean hasMoreElements() {
        boolean bl = false;
        if (this.m_bFirstEnum) {
            boolean bl2 = bl = this.m_aEnum1 != null && this.m_aEnum1.hasMoreElements();
            if (!bl) {
                this.m_bFirstEnum = false;
            }
        }
        if (!this.m_bFirstEnum) {
            bl = this.m_aEnum2 != null && this.m_aEnum2.hasMoreElements();
        }
        return bl;
    }

    @Override
    @Nullable
    public ELEMENTTYPE nextElement() {
        if (this.m_bFirstEnum) {
            return this.m_aEnum1.nextElement();
        }
        if (this.m_aEnum2 == null) {
            throw new NoSuchElementException();
        }
        return this.m_aEnum2.nextElement();
    }

    public String toString() {
        return new ToStringGenerator(this).append("enum1", this.m_aEnum1).append("enum2", this.m_aEnum2).toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> create(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration, @Nullable Enumeration<? extends ELEMENTTYPE> enumeration2) {
        if (enumeration == null && enumeration2 == null) {
            return EmptyEnumeration.getInstance();
        }
        return new CombinedEnumeration<ELEMENTTYPE>(enumeration, enumeration2);
    }
}

