/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.compare;

import com.helger.commons.compare.AbstractComparator;
import com.helger.commons.compare.CompareUtils;
import com.helger.commons.compare.ESortOrder;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ComparatorUtils {
    private static final ComparatorUtils s_aInstance = new ComparatorUtils();

    private ComparatorUtils() {
    }

    @Nonnull
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> Comparator<? super Map.Entry<KEYTYPE, VALUETYPE>> getComparatorMapEntryKey() {
        return ComparatorUtils.getComparatorMapEntryKey(ESortOrder.DEFAULT);
    }

    @Nonnull
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> Comparator<? super Map.Entry<KEYTYPE, VALUETYPE>> getComparatorMapEntryKey(@Nonnull ESortOrder eSortOrder) {
        return new AbstractComparator<Map.Entry<KEYTYPE, VALUETYPE>>(eSortOrder){

            @Override
            protected int mainCompare(Map.Entry<KEYTYPE, VALUETYPE> entry, Map.Entry<KEYTYPE, VALUETYPE> entry2) {
                return CompareUtils.nullSafeCompare((Comparable)entry.getKey(), (Comparable)entry2.getKey());
            }
        };
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> Comparator<? super Map.Entry<KEYTYPE, VALUETYPE>> getComparatorMapEntryKey(final Comparator<? super KEYTYPE> comparator) {
        return new Comparator<Map.Entry<KEYTYPE, VALUETYPE>>(){

            @Override
            public int compare(Map.Entry<KEYTYPE, VALUETYPE> entry, Map.Entry<KEYTYPE, VALUETYPE> entry2) {
                return comparator.compare(entry.getKey(), entry2.getKey());
            }
        };
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>> Comparator<? super Map.Entry<KEYTYPE, VALUETYPE>> getComparatorMapEntryValue() {
        return ComparatorUtils.getComparatorMapEntryValue(ESortOrder.DEFAULT);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>> Comparator<? super Map.Entry<KEYTYPE, VALUETYPE>> getComparatorMapEntryValue(@Nonnull ESortOrder eSortOrder) {
        return new AbstractComparator<Map.Entry<KEYTYPE, VALUETYPE>>(eSortOrder){

            @Override
            protected int mainCompare(Map.Entry<KEYTYPE, VALUETYPE> entry, Map.Entry<KEYTYPE, VALUETYPE> entry2) {
                return CompareUtils.nullSafeCompare((Comparable)entry.getValue(), (Comparable)entry2.getValue());
            }
        };
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> Comparator<? super Map.Entry<KEYTYPE, VALUETYPE>> getComparatorMapEntryValue(final @Nonnull Comparator<? super VALUETYPE> comparator) {
        return new Comparator<Map.Entry<KEYTYPE, VALUETYPE>>(){

            @Override
            public int compare(Map.Entry<KEYTYPE, VALUETYPE> entry, Map.Entry<KEYTYPE, VALUETYPE> entry2) {
                return comparator.compare(entry.getValue(), entry2.getValue());
            }
        };
    }
}

