/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file;

import com.helger.commons.io.file.EFileIOOperation;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.state.ISuccessIndicator;
import java.io.File;
import javax.annotation.Nonnull;

public enum EFileIOErrorCode implements ISuccessIndicator
{
    NO_ERROR,
    OPERATION_FAILED,
    SECURITY_ERROR,
    SOURCE_DOES_NOT_EXIST,
    TARGET_ALREADY_EXISTS,
    SOURCE_EQUALS_TARGET,
    TARGET_IS_CHILD_OF_SOURCE,
    OBJECT_CANNOT_BE_HANDLED,
    OBJECT_HAS_NO_PARENT,
    SOURCE_NOT_READABLE,
    SOURCE_PARENT_NOT_WRITABLE,
    TARGET_PARENT_NOT_WRITABLE;


    @Nonnull
    public FileIOError getAsIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull File file) {
        return new FileIOError(eFileIOOperation, this, file);
    }

    @Nonnull
    public FileIOError getAsIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull File file, @Nonnull File file2) {
        if (eFileIOOperation.getParamCount() < 2) {
            throw new IllegalStateException("The operation " + (Object)((Object)eFileIOOperation) + " expects only one parameter!");
        }
        return new FileIOError(eFileIOOperation, this, file, file2);
    }

    @Override
    public boolean isSuccess() {
        return this == NO_ERROR;
    }

    @Override
    public boolean isFailure() {
        return this != NO_ERROR;
    }

    @Nonnull
    public static FileIOError getAsIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull SecurityException securityException) {
        return new FileIOError(eFileIOOperation, SECURITY_ERROR, securityException);
    }
}

