/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streams;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.collections.ArrayHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;

public class ByteBufferOutputStream
extends OutputStream {
    public static final int DEFAULT_BUF_SIZE = 1024;
    public static final boolean DEFAULT_CAN_GROW = true;
    private ByteBuffer m_aBuffer;
    private final boolean m_bCanGrow;

    public ByteBufferOutputStream() {
        this(1024, true);
    }

    public ByteBufferOutputStream(@Nonnegative int n) {
        this(n, true);
    }

    public ByteBufferOutputStream(@Nonnegative int n, boolean bl) {
        this(ByteBuffer.allocate(n), bl);
    }

    public ByteBufferOutputStream(@Nonnull byte[] byArray) {
        this(ByteBuffer.wrap(byArray), false);
    }

    public ByteBufferOutputStream(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this(ByteBuffer.wrap(byArray, n, n2), false);
    }

    public ByteBufferOutputStream(@Nonnull ByteBuffer byteBuffer, boolean bl) {
        this.m_aBuffer = ValueEnforcer.notNull(byteBuffer, "Buffer");
        this.m_bCanGrow = bl;
    }

    @Nonnull
    public ByteBuffer getBuffer() {
        return this.m_aBuffer;
    }

    public boolean canGrow() {
        return this.m_bCanGrow;
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.m_aBuffer.clear();
    }

    @Nonnegative
    public int size() {
        return this.m_aBuffer.position();
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getAsByteArray() {
        byte[] byArray = this.m_aBuffer.array();
        int n = this.m_aBuffer.arrayOffset();
        int n2 = this.m_aBuffer.position();
        return ArrayHelper.getCopy(byArray, n, n2);
    }

    public void writeTo(@Nonnull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull(byteBuffer, "DestBuffer");
        this.m_aBuffer.flip();
        byteBuffer.put(this.m_aBuffer);
        this.m_aBuffer.compact();
    }

    public void writeTo(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Buffer");
        this.writeTo(byArray, 0, byArray.length);
    }

    public void writeTo(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this.m_aBuffer.flip();
        this.m_aBuffer.get(byArray, n, n2);
        this.m_aBuffer.compact();
    }

    public void writeTo(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        ValueEnforcer.notNull(outputStream, "OutputStream");
        outputStream.write(this.m_aBuffer.array(), this.m_aBuffer.arrayOffset(), this.m_aBuffer.position());
        this.m_aBuffer.clear();
    }

    @Nonnull
    public String getAsString(@Nonnull Charset charset) {
        return CharsetManager.getAsString(this.m_aBuffer.array(), this.m_aBuffer.arrayOffset(), this.m_aBuffer.position(), charset);
    }

    private void _growBy(@Nonnegative int n) {
        int n2 = this.m_aBuffer.capacity();
        int n3 = Math.max(n2 << 1, n2 + n);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        this.m_aBuffer.flip();
        byteBuffer.put(this.m_aBuffer);
        this.m_aBuffer = byteBuffer;
    }

    @Override
    public void write(int n) {
        if (this.m_bCanGrow && !this.m_aBuffer.hasRemaining()) {
            this._growBy(1);
        }
        this.m_aBuffer.put((byte)n);
    }

    @Override
    public void write(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (this.m_bCanGrow && n2 > this.m_aBuffer.remaining()) {
            this._growBy(n2);
        }
        this.m_aBuffer.put(byArray, n, n2);
    }

    public void write(@Nonnull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull(byteBuffer, "SourceBuffer");
        if (this.m_bCanGrow && byteBuffer.remaining() > this.m_aBuffer.remaining()) {
            this._growBy(byteBuffer.remaining());
        }
        this.m_aBuffer.put(byteBuffer);
    }
}

