/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streams;

import com.helger.commons.io.streams.WrappedOutputStream;
import com.helger.commons.messagedigest.EMessageDigestAlgorithm;
import com.helger.commons.messagedigest.IMessageDigestGenerator;
import com.helger.commons.messagedigest.NonBlockingMessageDigestGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class HashingOutputStream
extends WrappedOutputStream {
    private final IMessageDigestGenerator m_aMDGen;

    public HashingOutputStream(@Nonnull OutputStream outputStream, @Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm) {
        super(outputStream);
        this.m_aMDGen = new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithm);
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        this.m_aMDGen.update((byte)n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.m_aMDGen.update(byArray, n, n2);
    }

    @Nonnull
    public byte[] getDigest() {
        return this.m_aMDGen.getDigest();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("mdgen", this.m_aMDGen).toString();
    }
}

