/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streams;

import com.helger.commons.ValueEnforcer;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NonBlockingBufferedReader
extends Reader {
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private static final int DEFAULT_EXPECTED_LINE_LENGTH = 80;
    private Reader m_aReader;
    private char[] m_aBuf;
    private int m_nChars;
    private int m_nNextCharIndex;
    private int m_nMarkedChar = -1;
    private int m_nReadAheadLimit = 0;
    private boolean m_bSkipLF = false;
    private boolean m_bMarkedSkipLF = false;

    public NonBlockingBufferedReader(@Nonnull Reader reader) {
        this(reader, 8192);
    }

    public NonBlockingBufferedReader(@Nonnull Reader reader, @Nonnegative int n) {
        super((Object)reader);
        ValueEnforcer.isGT0(n, "Size");
        this.m_aReader = reader;
        this.m_aBuf = new char[n];
    }

    private void _ensureOpen() throws IOException {
        if (this.m_aReader == null) {
            throw new IOException("Stream closed");
        }
    }

    private void _fill() throws IOException {
        int n;
        int n2 = 0;
        if (this.m_nMarkedChar > -1) {
            n = this.m_nNextCharIndex - this.m_nMarkedChar;
            if (n >= this.m_nReadAheadLimit) {
                this.m_nMarkedChar = -2;
                this.m_nReadAheadLimit = 0;
            } else {
                if (this.m_nReadAheadLimit <= this.m_aBuf.length) {
                    System.arraycopy(this.m_aBuf, this.m_nMarkedChar, this.m_aBuf, 0, n);
                    this.m_nMarkedChar = 0;
                    n2 = n;
                } else {
                    char[] cArray = new char[this.m_nReadAheadLimit];
                    System.arraycopy(this.m_aBuf, this.m_nMarkedChar, cArray, 0, n);
                    this.m_aBuf = cArray;
                    this.m_nMarkedChar = 0;
                    n2 = n;
                }
                this.m_nNextCharIndex = n;
                this.m_nChars = n;
            }
        }
        while ((n = this.m_aReader.read(this.m_aBuf, n2, this.m_aBuf.length - n2)) == 0) {
        }
        if (n > 0) {
            this.m_nChars = n2 + n;
            this.m_nNextCharIndex = n2;
        }
    }

    @Override
    public int read() throws IOException {
        this._ensureOpen();
        while (true) {
            if (this.m_nNextCharIndex >= this.m_nChars) {
                this._fill();
                if (this.m_nNextCharIndex >= this.m_nChars) {
                    return -1;
                }
            }
            if (!this.m_bSkipLF) break;
            this.m_bSkipLF = false;
            if (this.m_aBuf[this.m_nNextCharIndex] != '\n') break;
            ++this.m_nNextCharIndex;
        }
        return this.m_aBuf[this.m_nNextCharIndex++];
    }

    private int _internalRead(char[] cArray, int n, int n2) throws IOException {
        if (this.m_nNextCharIndex >= this.m_nChars) {
            if (n2 >= this.m_aBuf.length && this.m_nMarkedChar <= -1 && !this.m_bSkipLF) {
                return this.m_aReader.read(cArray, n, n2);
            }
            this._fill();
        }
        if (this.m_nNextCharIndex >= this.m_nChars) {
            return -1;
        }
        if (this.m_bSkipLF) {
            this.m_bSkipLF = false;
            if (this.m_aBuf[this.m_nNextCharIndex] == '\n') {
                ++this.m_nNextCharIndex;
                if (this.m_nNextCharIndex >= this.m_nChars) {
                    this._fill();
                }
                if (this.m_nNextCharIndex >= this.m_nChars) {
                    return -1;
                }
            }
        }
        int n3 = Math.min(n2, this.m_nChars - this.m_nNextCharIndex);
        System.arraycopy(this.m_aBuf, this.m_nNextCharIndex, cArray, n, n3);
        this.m_nNextCharIndex += n3;
        return n3;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        this._ensureOpen();
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        if (n2 == 0) {
            return 0;
        }
        int n4 = this._internalRead(cArray, n, n2);
        if (n4 <= 0) {
            return n4;
        }
        while (n4 < n2 && this.m_aReader.ready() && (n3 = this._internalRead(cArray, n + n4, n2 - n4)) > 0) {
            n4 += n3;
        }
        return n4;
    }

    @Nullable
    public String readLine() throws IOException {
        StringBuilder stringBuilder = null;
        this._ensureOpen();
        boolean bl = this.m_bSkipLF;
        while (true) {
            int n;
            if (this.m_nNextCharIndex >= this.m_nChars) {
                this._fill();
            }
            if (this.m_nNextCharIndex >= this.m_nChars) {
                if (stringBuilder != null && stringBuilder.length() > 0) {
                    return stringBuilder.toString();
                }
                return null;
            }
            boolean bl2 = false;
            char c = '\u0000';
            if (!bl || this.m_aBuf[this.m_nNextCharIndex] == '\n') {
                // empty if block
            }
            this.m_bSkipLF = false;
            bl = false;
            for (n = ++this.m_nNextCharIndex; n < this.m_nChars; ++n) {
                c = this.m_aBuf[n];
                if (c != '\n' && c != '\r') continue;
                bl2 = true;
                break;
            }
            int n2 = this.m_nNextCharIndex;
            this.m_nNextCharIndex = n;
            if (bl2) {
                String string;
                if (stringBuilder == null) {
                    string = new String(this.m_aBuf, n2, n - n2);
                } else {
                    stringBuilder.append(this.m_aBuf, n2, n - n2);
                    string = stringBuilder.toString();
                }
                ++this.m_nNextCharIndex;
                if (c == '\r') {
                    this.m_bSkipLF = true;
                }
                return string;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(80);
            }
            stringBuilder.append(this.m_aBuf, n2, n - n2);
        }
    }

    @Override
    public long skip(long l) throws IOException {
        long l2;
        int n;
        ValueEnforcer.isGE0(l, "Bytes");
        this._ensureOpen();
        for (l2 = l; l2 > 0L; l2 -= (long)n) {
            if (this.m_nNextCharIndex >= this.m_nChars) {
                this._fill();
            }
            if (this.m_nNextCharIndex >= this.m_nChars) break;
            if (this.m_bSkipLF) {
                this.m_bSkipLF = false;
                if (this.m_aBuf[this.m_nNextCharIndex] == '\n') {
                    ++this.m_nNextCharIndex;
                }
            }
            if (l2 <= (long)(n = this.m_nChars - this.m_nNextCharIndex)) {
                this.m_nNextCharIndex = (int)((long)this.m_nNextCharIndex + l2);
                l2 = 0L;
                break;
            }
            this.m_nNextCharIndex = this.m_nChars;
        }
        return l - l2;
    }

    @Override
    public boolean ready() throws IOException {
        this._ensureOpen();
        if (this.m_bSkipLF) {
            if (this.m_nNextCharIndex >= this.m_nChars && this.m_aReader.ready()) {
                this._fill();
            }
            if (this.m_nNextCharIndex < this.m_nChars) {
                if (this.m_aBuf[this.m_nNextCharIndex] == '\n') {
                    ++this.m_nNextCharIndex;
                }
                this.m_bSkipLF = false;
            }
        }
        return this.m_nNextCharIndex < this.m_nChars || this.m_aReader.ready();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(@Nonnegative int n) throws IOException {
        ValueEnforcer.isGE0(n, "ReadAheadLimit");
        this._ensureOpen();
        this.m_nReadAheadLimit = n;
        this.m_nMarkedChar = this.m_nNextCharIndex;
        this.m_bMarkedSkipLF = this.m_bSkipLF;
    }

    @Override
    public void reset() throws IOException {
        this._ensureOpen();
        if (this.m_nMarkedChar < 0) {
            throw new IOException(this.m_nMarkedChar == -2 ? "Mark invalid" : "Stream not marked");
        }
        this.m_nNextCharIndex = this.m_nMarkedChar;
        this.m_bSkipLF = this.m_bMarkedSkipLF;
    }

    @Override
    public void close() throws IOException {
        if (this.m_aReader != null) {
            this.m_aReader.close();
            this.m_aReader = null;
            this.m_aBuf = null;
        }
    }
}

