/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.messagedigest;

import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.messagedigest.EMessageDigestAlgorithm;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public interface IMessageDigestGenerator {
    public static final EMessageDigestAlgorithm DEFAULT_ALGORITHM = EMessageDigestAlgorithm.SHA_512;

    @Nonnull
    public String getAlgorithmName();

    @Nonnegative
    public int getDigestLength();

    @Nonnull
    public IMessageDigestGenerator update(byte var1);

    @Nonnull
    @Deprecated
    public IMessageDigestGenerator update(@Nonnull String var1, @Nonnull String var2);

    @Nonnull
    public IMessageDigestGenerator update(@Nonnull String var1, @Nonnull Charset var2);

    @Nonnull
    public IMessageDigestGenerator update(@Nonnull byte[] var1);

    @Nonnull
    public IMessageDigestGenerator update(@Nonnull byte[] var1, @Nonnegative int var2, @Nonnegative int var3);

    public void reset();

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getDigest();

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getDigest(@Nonnegative int var1);

    public long getDigestLong();

    @Nonnull
    public String getDigestHexString();
}

