/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.messagedigest;

import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.messagedigest.AbstractMessageDigestGenerator;
import com.helger.commons.messagedigest.EMessageDigestAlgorithm;
import com.helger.commons.messagedigest.IMessageDigestGenerator;
import com.helger.commons.messagedigest.NonBlockingMessageDigestGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class MessageDigestGenerator
extends AbstractMessageDigestGenerator {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final IMessageDigestGenerator m_aMDGen;

    public MessageDigestGenerator() {
        this(DEFAULT_ALGORITHM);
    }

    public MessageDigestGenerator(EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        this.m_aMDGen = new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithmArray);
    }

    @Override
    @Nonnull
    public String getAlgorithmName() {
        return this.m_aMDGen.getAlgorithmName();
    }

    @Override
    @Nonnegative
    public int getDigestLength() {
        return this.m_aMDGen.getDigestLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public MessageDigestGenerator update(byte by) {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMDGen.update(by);
            MessageDigestGenerator messageDigestGenerator = this;
            return messageDigestGenerator;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public MessageDigestGenerator update(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMDGen.update(byArray, n, n2);
            MessageDigestGenerator messageDigestGenerator = this;
            return messageDigestGenerator;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMDGen.reset();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public byte[] getDigest() {
        this.m_aRWLock.writeLock().lock();
        try {
            byte[] byArray = this.m_aMDGen.getDigest();
            return byArray;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public byte[] getDigest(@Nonnegative int n) {
        this.m_aRWLock.writeLock().lock();
        try {
            byte[] byArray = this.m_aMDGen.getDigest(n);
            return byArray;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("messageDigestGenerator", this.m_aMDGen).toString();
    }
}

