/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.microdom.IMicroContainer;
import com.helger.commons.microdom.IMicroDocument;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.impl.MicroCDATA;
import com.helger.commons.microdom.impl.MicroComment;
import com.helger.commons.microdom.impl.MicroContainer;
import com.helger.commons.microdom.impl.MicroDocument;
import com.helger.commons.microdom.impl.MicroDocumentType;
import com.helger.commons.microdom.impl.MicroElement;
import com.helger.commons.microdom.impl.MicroEntityReference;
import com.helger.commons.microdom.impl.MicroProcessingInstruction;
import com.helger.commons.microdom.impl.MicroText;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

@Immutable
public final class MicroUtils {
    private static final MicroUtils s_aInstance = new MicroUtils();

    private MicroUtils() {
    }

    @Nonnull
    public static IMicroNode append(@Nonnull IMicroNode iMicroNode, @Nullable Object object) {
        ValueEnforcer.notNull(iMicroNode, "SrcNode");
        if (object != null) {
            if (object instanceof IMicroNode) {
                iMicroNode.appendChild((IMicroNode)object);
            } else if (object instanceof String) {
                iMicroNode.appendText((String)object);
            } else if (object instanceof Iterable) {
                for (Object t : (Iterable)object) {
                    MicroUtils.append(iMicroNode, t);
                }
            } else if (ArrayHelper.isArray(object)) {
                for (Object object2 : (Object[])object) {
                    MicroUtils.append(iMicroNode, object2);
                }
            } else {
                throw new IllegalArgumentException("Passed object cannot be appended to an IMicroNode (type=" + object.getClass().getName() + ".");
            }
        }
        return iMicroNode;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public static String getPath(@Nullable IMicroNode iMicroNode, @Nonnull String string) {
        ValueEnforcer.notNull(string, "Separator");
        StringBuilder stringBuilder = new StringBuilder();
        for (IMicroNode iMicroNode2 = iMicroNode; iMicroNode2 != null; iMicroNode2 = iMicroNode2.getParent()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, string);
            }
            stringBuilder.insert(0, iMicroNode2.getNodeName());
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static String getDocumentRootElementTagName(@Nullable IMicroDocument iMicroDocument) {
        IMicroElement iMicroElement;
        if (iMicroDocument != null && (iMicroElement = iMicroDocument.getDocumentElement()) != null) {
            return iMicroElement.getTagName();
        }
        return null;
    }

    @Nonnull
    public static IMicroNode convertToMicroNode(@Nonnull Node node) {
        int n;
        Object object;
        Object object2;
        ValueEnforcer.notNull(node, "Node");
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                object2 = new MicroDocument();
                break;
            }
            case 10: {
                object = (DocumentType)node;
                object2 = new MicroDocumentType(object.getName(), object.getPublicId(), object.getSystemId());
                break;
            }
            case 1: {
                object = new MicroElement(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    n = namedNodeMap.getLength();
                    for (int i = 0; i < n; ++i) {
                        Attr attr = (Attr)namedNodeMap.item(i);
                        object.setAttribute(attr.getName(), attr.getValue());
                    }
                }
                object2 = object;
                break;
            }
            case 4: {
                object2 = new MicroCDATA(node.getNodeValue());
                break;
            }
            case 3: {
                object2 = new MicroText(node.getNodeValue());
                break;
            }
            case 8: {
                object2 = new MicroComment(node.getNodeValue());
                break;
            }
            case 5: {
                object2 = new MicroEntityReference(node.getNodeValue());
                break;
            }
            case 7: {
                object = (ProcessingInstruction)node;
                object2 = new MicroProcessingInstruction(object.getTarget(), object.getData());
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Unknown/unsupported node type: ATTRIBUTE_NODE");
            }
            case 6: {
                throw new IllegalArgumentException("Unknown/unsupported node type: ENTITY_NODE");
            }
            case 11: {
                throw new IllegalArgumentException("Unknown/unsupported node type: DOCUMENT_FRAGMENT_NODE");
            }
            case 12: {
                throw new IllegalArgumentException("Unknown/unsupported node type: NOTATION_NODE");
            }
            default: {
                throw new IllegalArgumentException("Unknown/unsupported node type: " + s);
            }
        }
        object = node.getChildNodes();
        if (object != null) {
            int n2 = object.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = object.item(n);
                object2.appendChild(MicroUtils.convertToMicroNode(node2));
            }
        }
        return object2;
    }

    @Nullable
    public static String getChildTextContent(@Nonnull IMicroElement iMicroElement, @Nonnull String string) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? iMicroElement2.getTextContent() : null;
    }

    @Nullable
    public static String getChildTextContentTrimmed(@Nonnull IMicroElement iMicroElement, @Nonnull String string) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? iMicroElement2.getTextContentTrimmed() : null;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE getChildTextContentWithConversion(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull Class<DSTTYPE> clazz) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? (DSTTYPE)iMicroElement2.getTextContentWithConversion(clazz) : null;
    }

    @Nullable
    public static String getChildTextContent(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull String string2) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, string2);
        return iMicroElement2 != null ? iMicroElement2.getTextContent() : null;
    }

    @Nullable
    public static String getChildTextContentTrimmed(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull String string2) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, string2);
        return iMicroElement2 != null ? iMicroElement2.getTextContentTrimmed() : null;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE getChildTextContentWithConversion(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull String string2, @Nonnull Class<DSTTYPE> clazz) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, string2);
        return iMicroElement2 != null ? (DSTTYPE)iMicroElement2.getTextContentWithConversion(clazz) : null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IMicroContainer getAllChildrenAsContainer(@Nonnull IMicroNode iMicroNode) {
        MicroContainer microContainer = new MicroContainer();
        if (iMicroNode.hasChildren()) {
            for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                microContainer.appendChild((IMicroNode)iMicroNode2.getClone());
            }
        }
        return microContainer;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IMicroContainer getAllOriginalChildrenAsContainer(@Nonnull IMicroNode iMicroNode) {
        MicroContainer microContainer = new MicroContainer();
        if (iMicroNode.hasChildren()) {
            for (IMicroNode iMicroNode2 : iMicroNode.getChildren()) {
                microContainer.appendChild(iMicroNode2.detachFromParent());
            }
        }
        return microContainer;
    }
}

