/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.thirdparty;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.lang.ServiceLoaderUtils;
import com.helger.commons.state.EChange;
import com.helger.commons.thirdparty.IThirdPartyModule;
import com.helger.commons.thirdparty.IThirdPartyModuleProviderSPI;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ThirdPartyModuleRegistry {
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Set<IThirdPartyModule> s_aModules = new LinkedHashSet<IThirdPartyModule>();
    private static final ThirdPartyModuleRegistry s_aInstance;

    private ThirdPartyModuleRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange registerThirdPartyModule(@Nonnull IThirdPartyModule iThirdPartyModule) {
        ValueEnforcer.notNull(iThirdPartyModule, "Module");
        s_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(s_aModules.add(iThirdPartyModule));
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<IThirdPartyModule> getAllRegisteredThirdPartyModules() {
        s_aRWLock.readLock().lock();
        try {
            Set<IThirdPartyModule> set = ContainerHelper.newSet(s_aModules);
            return set;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reinitialize() {
        s_aRWLock.writeLock().lock();
        try {
            s_aModules.clear();
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
        for (IThirdPartyModuleProviderSPI iThirdPartyModuleProviderSPI : ServiceLoaderUtils.getAllSPIImplementations(IThirdPartyModuleProviderSPI.class)) {
            IThirdPartyModule[] iThirdPartyModuleArray = iThirdPartyModuleProviderSPI.getAllThirdPartyModules();
            if (iThirdPartyModuleArray == null) continue;
            for (IThirdPartyModule iThirdPartyModule : iThirdPartyModuleArray) {
                ThirdPartyModuleRegistry.registerThirdPartyModule(iThirdPartyModule);
            }
        }
    }

    static {
        ThirdPartyModuleRegistry.reinitialize();
        s_aInstance = new ThirdPartyModuleRegistry();
    }
}

