/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert.impl;

import com.helger.commons.annotations.IsSPIImplementation;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IInputStreamProvider;
import com.helger.commons.io.IOutputStreamProvider;
import com.helger.commons.io.IReaderProvider;
import com.helger.commons.io.IResourceBase;
import com.helger.commons.io.IWriterProvider;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.typeconvert.ITypeConverter;
import com.helger.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.commons.typeconvert.ITypeConverterRegistry;
import com.helger.commons.typeconvert.rule.AbstractTypeConverterRuleAssignableSourceFixedDestination;
import com.helger.commons.url.URLUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class IOTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverter(File.class, String.class, new ITypeConverter(){

            @Override
            public String convert(@Nonnull Object object) {
                return ((File)object).getAbsolutePath();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(File.class, URI.class, new ITypeConverter(){

            @Override
            public URI convert(@Nonnull Object object) {
                return ((File)object).toURI();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(File.class, URL.class, new ITypeConverter(){

            @Override
            public URL convert(@Nonnull Object object) {
                return URLUtils.getAsURL(((File)object).toURI());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URI.class, File.class, new ITypeConverter(){

            @Override
            public File convert(@Nonnull Object object) {
                return new File((URI)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URI.class, URL.class, new ITypeConverter(){

            @Override
            public URL convert(@Nonnull Object object) {
                return URLUtils.getAsURL((URI)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URL.class, String.class, new ITypeConverter(){

            @Override
            public String convert(@Nonnull Object object) {
                return ((URL)object).toExternalForm();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URL.class, File.class, new ITypeConverter(){

            @Override
            public File convert(@Nonnull Object object) {
                URL uRL = (URL)object;
                try {
                    return new File(uRL.toURI().getSchemeSpecificPart());
                }
                catch (URISyntaxException uRISyntaxException) {
                    return new File(uRL.getPath());
                }
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URL.class, URI.class, new ITypeConverter(){

            @Override
            public URI convert(@Nonnull Object object) {
                return URLUtils.getAsURI((URL)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(String.class, File.class, new ITypeConverter(){

            @Override
            public File convert(@Nonnull Object object) {
                return new File((String)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(String.class, URI.class, new ITypeConverter(){

            @Override
            public URI convert(@Nonnull Object object) {
                return URLUtils.getAsURI((String)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(String.class, URL.class, new ITypeConverter(){

            @Override
            public URL convert(@Nonnull Object object) {
                return URLUtils.getAsURL((String)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IResourceBase.class, String.class){

            @Override
            public String convert(@Nonnull Object object) {
                return ((IResourceBase)object).getPath();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IResourceBase.class, URL.class){

            @Override
            public URL convert(@Nonnull Object object) {
                return ((IResourceBase)object).getAsURL();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IResourceBase.class, File.class){

            @Override
            public File convert(@Nonnull Object object) {
                return ((IResourceBase)object).getAsFile();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IInputStreamProvider.class, InputStream.class){

            @Override
            public InputStream convert(@Nonnull Object object) {
                return ((IInputStreamProvider)object).getInputStream();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IOutputStreamProvider.class, OutputStream.class){

            @Override
            public OutputStream convert(@Nonnull Object object) {
                return ((IOutputStreamProvider)object).getOutputStream(EAppend.DEFAULT);
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IReaderProvider.class, Reader.class){

            @Override
            public Reader convert(@Nonnull Object object) {
                return ((IReaderProvider)object).getReader();
            }
        });
        iTypeConverterRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(IWriterProvider.class, Writer.class){

            @Override
            public Writer convert(@Nonnull Object object) {
                return ((IWriterProvider)object).getWriter();
            }
        });
        iTypeConverterRegistry.registerTypeConverter(String.class, ClassPathResource.class, new ITypeConverter(){

            @Override
            public ClassPathResource convert(@Nonnull Object object) {
                return new ClassPathResource((String)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URL.class, ClassPathResource.class, new ITypeConverter(){

            @Override
            public ClassPathResource convert(@Nonnull Object object) {
                return new ClassPathResource((URL)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(String.class, FileSystemResource.class, new ITypeConverter(){

            @Override
            public FileSystemResource convert(@Nonnull Object object) {
                return new FileSystemResource((String)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URL.class, FileSystemResource.class, new ITypeConverter(){

            @Override
            public FileSystemResource convert(@Nonnull Object object) {
                try {
                    URI uRI = ((URL)object).toURI();
                    return new FileSystemResource(uRI);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return null;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(String.class, URLResource.class, new ITypeConverter(){

            @Override
            public URLResource convert(@Nonnull Object object) {
                try {
                    return new URLResource((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URL.class, URLResource.class, new ITypeConverter(){

            @Override
            public URLResource convert(@Nonnull Object object) {
                return new URLResource((URL)object);
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URI.class, URLResource.class, new ITypeConverter(){

            @Override
            public URLResource convert(@Nonnull Object object) {
                try {
                    return new URLResource((URI)object);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
        });
    }
}

