/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml;

import com.helger.commons.filter.IFilter;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@NotThreadSafe
public final class FilterNodeIsElement
implements IFilter<Node> {
    private final IFilter<Element> m_aNestedElementFilter;

    public FilterNodeIsElement() {
        this(null);
    }

    public FilterNodeIsElement(@Nullable IFilter<Element> iFilter) {
        this.m_aNestedElementFilter = iFilter;
    }

    @Override
    public boolean matchesFilter(@Nullable Node node) {
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        return this.m_aNestedElementFilter == null || this.m_aNestedElementFilter.matchesFilter((Element)node);
    }

    @Nullable
    public IFilter<Element> getNestedElementFilter() {
        return this.m_aNestedElementFilter;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilterNodeIsElement)) {
            return false;
        }
        FilterNodeIsElement filterNodeIsElement = (FilterNodeIsElement)object;
        return this.m_aNestedElementFilter.equals(filterNodeIsElement.m_aNestedElementFilter);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aNestedElementFilter).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("customFilter", this.m_aNestedElementFilter).toString();
    }
}

