/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.sax;

import com.helger.commons.io.IInputStreamProvider;
import com.helger.commons.io.IReadableResource;
import com.helger.commons.io.streams.NonBlockingByteArrayInputStream;
import com.helger.commons.io.streams.StreamUtils;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.xml.sax.InputSource;

@NotThreadSafe
public class CachingSAXInputSource
extends InputSource {
    @Nonnull
    private static NonBlockingByteArrayInputStream _getCachedInputStream(@Nonnull @WillClose InputStream inputStream) {
        return new NonBlockingByteArrayInputStream(StreamUtils.getAllBytes(inputStream));
    }

    public CachingSAXInputSource(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource.getInputStream(), iReadableResource.getResourceID());
    }

    public CachingSAXInputSource(@Nonnull IInputStreamProvider iInputStreamProvider) {
        this(iInputStreamProvider.getInputStream(), null);
    }

    public CachingSAXInputSource(@Nonnull IInputStreamProvider iInputStreamProvider, @Nullable String string) {
        this(iInputStreamProvider.getInputStream(), string);
    }

    public CachingSAXInputSource(@Nonnull @WillClose InputStream inputStream) {
        this(inputStream, null);
    }

    public CachingSAXInputSource(@Nonnull @WillClose InputStream inputStream, @Nullable String string) {
        super(CachingSAXInputSource._getCachedInputStream(inputStream));
        this.setSystemId(string);
    }
}

