/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.serialize;

import com.helger.commons.exceptions.InitializationException;
import com.helger.commons.factory.IFactory;
import com.helger.commons.xml.serialize.XMLReaderFactoryPH;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class SAXReaderFactory
implements IFactory<XMLReader> {
    @Override
    @Nonnull
    public XMLReader create() {
        return SAXReaderFactory.createXMLReader();
    }

    @Nonnull
    public static XMLReader createXMLReader() {
        try {
            XMLReader xMLReader = XMLReaderFactoryPH.createXMLReader();
            return xMLReader;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InitializationException("Failed to instantiate XML reader!", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new InitializationException("Failed to instantiate XML reader!", sAXException);
        }
    }
}

