/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.xpath;

import com.helger.commons.ICloneable;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;

@NotThreadSafe
public class MapBasedXPathVariableResolverQName
implements XPathVariableResolver,
ICloneable<MapBasedXPathVariableResolverQName> {
    private final Map<QName, Object> m_aVars;

    public MapBasedXPathVariableResolverQName() {
        this((Map)null);
    }

    public MapBasedXPathVariableResolverQName(@Nullable Map<QName, ?> map) {
        this.m_aVars = ContainerHelper.newMap(map);
    }

    public MapBasedXPathVariableResolverQName(@Nonnull MapBasedXPathVariableResolverQName mapBasedXPathVariableResolverQName) {
        ValueEnforcer.notNull(mapBasedXPathVariableResolverQName, "Other");
        this.m_aVars = ContainerHelper.newMap(mapBasedXPathVariableResolverQName.m_aVars);
    }

    @Nonnull
    public EChange addUniqueVariable(@Nonnull QName qName, @Nonnull Object object) {
        ValueEnforcer.notNull(qName, "Name");
        ValueEnforcer.notNull(object, "Value");
        if (this.m_aVars.containsKey(qName)) {
            return EChange.UNCHANGED;
        }
        this.m_aVars.put(qName, object);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeVariable(@Nullable QName qName) {
        return EChange.valueOf(this.m_aVars.remove(qName) != null);
    }

    @Nonnull
    public EChange removeVariables(@Nullable Iterable<QName> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (QName qName : iterable) {
                eChange = eChange.or(this.removeVariable(qName));
            }
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Map<QName, ?> getAllVariables() {
        return ContainerHelper.newMap(this.m_aVars);
    }

    @Nonnegative
    public int getVariableCount() {
        return this.m_aVars.size();
    }

    @Nonnull
    public EChange clear() {
        if (this.m_aVars.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aVars.clear();
        return EChange.CHANGED;
    }

    public void setAllVariables(@Nullable Map<QName, ?> map) {
        this.m_aVars.clear();
        if (map != null) {
            this.m_aVars.putAll(map);
        }
    }

    @Override
    @Nullable
    public Object resolveVariable(@Nonnull QName qName) {
        ValueEnforcer.notNull(qName, "VariableName");
        return this.m_aVars.get(qName);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public MapBasedXPathVariableResolverQName getClone() {
        return new MapBasedXPathVariableResolverQName(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedXPathVariableResolverQName mapBasedXPathVariableResolverQName = (MapBasedXPathVariableResolverQName)object;
        return EqualsUtils.equals(this.m_aVars, mapBasedXPathVariableResolverQName.m_aVars);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aVars)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("vars", this.m_aVars).toString();
    }
}

