/**
 * Copyright (C) 2014 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.commons.convert;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.helger.commons.id.IHasID;

/**
 * A unidirectional converter that extracts the ID from an object implementing
 * {@link IHasID}.
 * 
 * @author Philip Helger
 * @param <DATATYPE>
 *        The ID type
 */
public final class UnidirectionalConverterHasIDID <DATATYPE> implements
                                                             IUnidirectionalConverter <IHasID <DATATYPE>, DATATYPE>
{
  @Nullable
  public DATATYPE convert (@Nullable final IHasID <DATATYPE> aInput)
  {
    return aInput == null ? null : aInput.getID ();
  }

  @Nonnull
  public static <DATATYPE> UnidirectionalConverterHasIDID <DATATYPE> create ()
  {
    return new UnidirectionalConverterHasIDID <DATATYPE> ();
  }
}
