/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.charset;

import com.helger.commons.ValueEnforcer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class StringDecoder {
    public static final int INITIAL_BUFFER_SIZE = 1024;
    private static final int SIZE_ALIGNMENT_BITS = 10;
    private static final int SIZE_ALIGNMENT = 1024;
    private static final int SIZE_ALIGNMENT_MASK = 1023;
    private final CharsetDecoder m_aDecoder;
    private CharBuffer m_aBuffer = CharBuffer.allocate(1024);

    public StringDecoder(@Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        this.m_aDecoder = charset.newDecoder();
        this.m_aDecoder.onMalformedInput(CodingErrorAction.REPLACE);
    }

    public void reserve(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ExpectedLength");
        if (this.m_aBuffer.position() != 0) {
            throw new IllegalStateException("cannot be called except after finish()");
        }
        if (n > this.m_aBuffer.capacity()) {
            int n2 = n;
            if ((n2 & 0x3FF) != 0) {
                n2 = n + 1024 & 0xFFFFFC00;
            }
            assert (n2 % 1024 == 0);
            this.m_aBuffer = CharBuffer.allocate(n2);
        }
        assert (this.m_aBuffer.position() == 0);
        assert (n <= this.m_aBuffer.capacity());
    }

    private void _decode(@Nonnull ByteBuffer byteBuffer, boolean bl) {
        do {
            CoderResult coderResult;
            if ((coderResult = this.m_aDecoder.decode(byteBuffer, this.m_aBuffer, bl)) == CoderResult.UNDERFLOW) continue;
            if (coderResult == CoderResult.OVERFLOW) {
                CharBuffer charBuffer = CharBuffer.allocate(this.m_aBuffer.capacity() * 2);
                System.arraycopy(this.m_aBuffer.array(), 0, charBuffer.array(), 0, this.m_aBuffer.position());
                charBuffer.position(this.m_aBuffer.position());
                assert (charBuffer.remaining() >= this.m_aBuffer.capacity());
                this.m_aBuffer = charBuffer;
                continue;
            }
            assert (false);
            assert (coderResult.isMalformed());
        } while (byteBuffer.hasRemaining());
        assert (!byteBuffer.hasRemaining());
    }

    public void decode(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Buffer");
        this._decode(ByteBuffer.wrap(byArray, 0, byArray.length), false);
    }

    public void decode(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this._decode(ByteBuffer.wrap(byArray, n, n2), false);
    }

    public void decode(@Nonnull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull(byteBuffer, "ByteBuffer");
        this._decode(byteBuffer, false);
    }

    @Nonnull
    public String finish(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return this.finish(ByteBuffer.wrap(byArray, n, n2));
    }

    @Nonnull
    public String finish(@Nonnull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull(byteBuffer, "ByteBuffer");
        this._decode(byteBuffer, true);
        CoderResult coderResult = this.m_aDecoder.flush(this.m_aBuffer);
        if (coderResult == CoderResult.OVERFLOW) {
            throw new IllegalStateException("TODO: Handle overflow?");
        }
        if (coderResult != CoderResult.UNDERFLOW) {
            throw new IllegalStateException("TODO: Handle errors?");
        }
        String string = new String(this.m_aBuffer.array(), 0, this.m_aBuffer.position());
        this.m_aBuffer.clear();
        this.m_aDecoder.reset();
        return string;
    }
}

