/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.charset;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.EFinish;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class StringEncoder {
    public static final int CHAR_BUFFER_SIZE = 1024;
    public static final int BYTE_BUFFER_SIZE = 2048;
    private static final int BUFFER_EXTRA_BYTES = 64;
    public static final int UTF8_MAX_BYTES_PER_CHAR = 3;
    private final CharBuffer m_aInChar = CharBuffer.allocate(1024);
    private final ByteBuffer m_aArrayBuffer = ByteBuffer.allocate(2048);
    private final CharsetEncoder m_aEncoder;
    private int m_nReadOffset = 0;

    public StringEncoder(@Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        this.m_aEncoder = charset.newEncoder();
        this.m_aInChar.position(this.m_aInChar.limit());
        this.m_aEncoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.m_aEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    private void _readInputChunk(@Nonnull String string) {
        assert (this.m_aInChar.remaining() <= 1);
        assert (this.m_nReadOffset < string.length());
        char[] cArray = this.m_aInChar.array();
        int n = string.length() - this.m_nReadOffset;
        if (n > cArray.length) {
            n = cArray.length;
        }
        string.getChars(this.m_nReadOffset, this.m_nReadOffset + n, cArray, 0);
        this.m_aInChar.position(0);
        this.m_aInChar.limit(n);
        this.m_nReadOffset += n;
    }

    @Nonnull
    public EFinish encode(@Nonnull String string, @Nonnull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull(string, "Source");
        ValueEnforcer.notNull(byteBuffer, "DestBuffer");
        if (string.length() == 0) {
            return EFinish.FINISHED;
        }
        if (!this.m_aInChar.hasRemaining() && this.m_nReadOffset < string.length()) {
            this._readInputChunk(string);
        }
        if (this.m_aInChar.hasRemaining()) {
            while (true) {
                assert (this.m_aInChar.hasRemaining());
                boolean bl = this.m_nReadOffset == string.length();
                CoderResult coderResult = this.m_aEncoder.encode(this.m_aInChar, byteBuffer, bl);
                if (coderResult == CoderResult.OVERFLOW) {
                    assert ((float)byteBuffer.remaining() < this.m_aEncoder.maxBytesPerChar());
                    return EFinish.UNFINISHED;
                }
                assert (coderResult == CoderResult.UNDERFLOW);
                assert (this.m_aInChar.remaining() <= 1);
                this.m_nReadOffset -= this.m_aInChar.remaining();
                assert (this.m_nReadOffset > 0);
                if (this.m_nReadOffset == string.length()) break;
                this._readInputChunk(string);
            }
        }
        assert (!this.m_aInChar.hasRemaining());
        assert (this.m_nReadOffset == string.length());
        CoderResult coderResult = this.m_aEncoder.flush(byteBuffer);
        if (coderResult == CoderResult.OVERFLOW) {
            assert (false);
            return EFinish.UNFINISHED;
        }
        assert (coderResult == CoderResult.UNDERFLOW);
        this.reset();
        return EFinish.FINISHED;
    }

    @Nonnegative
    private int _getCharsConverted() {
        int n = this.m_nReadOffset - this.m_aInChar.remaining();
        assert (0 <= n && n <= this.m_nReadOffset);
        return n;
    }

    @Nonnull
    public ByteBuffer getAsNewByteBuffer(@Nonnull String string) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(string.length() + 64);
        while (this.encode(string, byteBuffer).isUnfinished()) {
            int n = this._getCharsConverted();
            double d = n > 0 ? (double)byteBuffer.position() / (double)n : (double)this.m_aEncoder.averageBytesPerChar();
            int n2 = string.length() - n;
            assert (n2 > 0);
            int n3 = (int)((double)n2 * d + 0.5);
            int n4 = byteBuffer.position();
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.position() + n3 + 64);
            byteBuffer.flip();
            byteBuffer2.put(byteBuffer);
            byteBuffer2.position(n4);
            byteBuffer = byteBuffer2;
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    @Nonnull
    public byte[] getAsNewArray(@Nonnull String string) {
        assert (this.m_aArrayBuffer.remaining() == this.m_aArrayBuffer.capacity());
        if (this.encode(string, this.m_aArrayBuffer).isFinished()) {
            byte[] byArray = new byte[this.m_aArrayBuffer.position()];
            System.arraycopy(this.m_aArrayBuffer.array(), 0, byArray, 0, this.m_aArrayBuffer.position());
            this.m_aArrayBuffer.clear();
            return byArray;
        }
        int n = string.length() - this._getCharsConverted();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n * 3);
        EFinish eFinish = this.encode(string, byteBuffer);
        assert (eFinish.isFinished());
        byte[] byArray = new byte[this.m_aArrayBuffer.position() + byteBuffer.position()];
        System.arraycopy(this.m_aArrayBuffer.array(), 0, byArray, 0, this.m_aArrayBuffer.position());
        System.arraycopy(byteBuffer.array(), 0, byArray, this.m_aArrayBuffer.position(), byteBuffer.position());
        this.m_aArrayBuffer.clear();
        return byArray;
    }

    public void reset() {
        this.m_nReadOffset = 0;
        this.m_aInChar.position(0);
        this.m_aInChar.limit(0);
        this.m_aEncoder.reset();
    }
}

