/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.cleanup;

import com.helger.commons.SystemProperties;
import com.helger.commons.compare.CollatorUtils;
import com.helger.commons.equals.EqualsImplementationRegistry;
import com.helger.commons.gfx.ImageDataManager;
import com.helger.commons.hash.HashCodeImplementationRegistry;
import com.helger.commons.jaxb.JAXBContextCache;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.locale.LocaleUtils;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.microdom.convert.MicroTypeConverterRegistry;
import com.helger.commons.mime.MimeTypeDeterminator;
import com.helger.commons.mime.MimeTypeInfoManager;
import com.helger.commons.regex.RegExPool;
import com.helger.commons.serialize.convert.SerializationConverterRegistry;
import com.helger.commons.stats.StatisticsManager;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.resource.ResourceBundleUtils;
import com.helger.commons.thirdparty.ThirdPartyModuleRegistry;
import com.helger.commons.typeconvert.TypeConverterRegistry;
import com.helger.commons.url.URLProtocolRegistry;
import com.helger.commons.xml.schema.XMLSchemaCache;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CommonsCleanup {
    private static final CommonsCleanup s_aInstance = new CommonsCleanup();

    private CommonsCleanup() {
    }

    public static void cleanup() {
        LocaleCache.resetCache();
        CountryCache.resetCache();
        MimeTypeDeterminator.resetCache();
        MimeTypeInfoManager.getDefaultInstance().resetCache();
        MicroTypeConverterRegistry.reinitialize();
        SerializationConverterRegistry.reinitialize();
        ThirdPartyModuleRegistry.reinitialize();
        TypeConverterRegistry.reinitialize();
        URLProtocolRegistry.reinitialize();
        ImageDataManager.clearCache();
        DefaultTextResolver.clearCache();
        EnumHelper.clearCache();
        ResourceBundleUtils.clearCache();
        RegExPool.clearPatternCache();
        CollatorUtils.clearCache();
        LocaleUtils.clearCache();
        if (JAXBContextCache.isInstantiated()) {
            JAXBContextCache.getInstance().clearCache();
        }
        if (XMLSchemaCache.isInstantiated()) {
            XMLSchemaCache.getInstance().clearCache();
        }
        StatisticsManager.clearCache();
        EqualsImplementationRegistry.clearCache();
        HashCodeImplementationRegistry.clearCache();
        SystemProperties.clearWarnedPropertyNames();
        ClassHierarchyCache.clearCache();
    }
}

