/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.codec.AbstractCodec;
import com.helger.commons.codec.DecoderException;
import com.helger.commons.codec.EncoderException;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.io.streams.NonBlockingBitInputStream;
import com.helger.commons.io.streams.NonBlockingBitOutputStream;
import com.helger.commons.io.streams.NonBlockingByteArrayInputStream;
import com.helger.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.string.ToStringGenerator;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LZWCodec
extends AbstractCodec {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LZWCodec.class);

    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] byArray) {
        return LZWCodec.decodeLZW(byArray);
    }

    @Nullable
    public static byte[] decodeLZW(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        LZWCodec.decodeLZW(nonBlockingByteArrayInputStream, nonBlockingByteArrayOutputStream);
        StreamUtils.close(nonBlockingByteArrayOutputStream);
        StreamUtils.close(nonBlockingByteArrayInputStream);
        return nonBlockingByteArrayOutputStream.toByteArray();
    }

    public static void decodeLZW(@Nonnull @WillNotClose InputStream inputStream, @Nonnull @WillNotClose OutputStream outputStream) {
        block12: {
            ValueEnforcer.notNull(inputStream, "EncodedInputStream");
            ValueEnforcer.notNull(outputStream, "OutputStream");
            NonBlockingBitInputStream nonBlockingBitInputStream = new NonBlockingBitInputStream(inputStream, ByteOrder.LITTLE_ENDIAN);
            try {
                LZWDecodeDictionary lZWDecodeDictionary = new LZWDecodeDictionary();
                lZWDecodeDictionary.reset();
                int n = lZWDecodeDictionary.readCode(nonBlockingBitInputStream);
                while (n == 256) {
                    n = lZWDecodeDictionary.readCode(nonBlockingBitInputStream);
                }
                if (n == 257) break block12;
                byte[] byArray = lZWDecodeDictionary.getBytes(n);
                if (byArray == null) {
                    throw new DecoderException("Failed to resolve initial code " + n);
                }
                outputStream.write(byArray);
                byte[] byArray2 = byArray;
                while ((n = lZWDecodeDictionary.readCode(nonBlockingBitInputStream)) != 257) {
                    if (n == 256) {
                        lZWDecodeDictionary.reset();
                        n = lZWDecodeDictionary.readCode(nonBlockingBitInputStream);
                        if (n != 257) {
                            byArray = lZWDecodeDictionary.getBytes(n);
                            outputStream.write(byArray);
                            byArray2 = byArray;
                            continue;
                        }
                        break;
                    }
                    int n2 = lZWDecodeDictionary.getNextFreeCode();
                    if (n < n2) {
                        byArray = lZWDecodeDictionary.getBytes(n);
                    } else if (n == n2) {
                        byArray = ArrayHelper.getConcatenated(byArray2, byArray2[0]);
                    } else {
                        throw new DecoderException("Error decoding LZW: unexpected code " + n + " while next free code is " + n2);
                    }
                    outputStream.write(byArray);
                    lZWDecodeDictionary.addEntry(ArrayHelper.getConcatenated(byArray2, byArray[0]), false);
                    byArray2 = byArray;
                }
            }
            catch (EOFException eOFException) {
                throw new DecoderException("Unexpected EOF decoding LZW", eOFException);
            }
            catch (IOException iOException) {
                throw new DecoderException("Error decoding LZW", iOException);
            }
        }
    }

    @Override
    @Nullable
    public byte[] encode(@Nullable byte[] byArray) {
        return LZWCodec.encodeLZW(byArray);
    }

    @Nullable
    public static byte[] encodeLZW(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        LZWCodec.encodeLZW(byArray, nonBlockingByteArrayOutputStream);
        return nonBlockingByteArrayOutputStream.toByteArray();
    }

    public static void encodeLZW(@Nullable byte[] byArray, @Nonnull @WillNotClose OutputStream outputStream) {
        ValueEnforcer.notNull(outputStream, "OutputStream");
        if (byArray == null) {
            return;
        }
        NonBlockingBitOutputStream nonBlockingBitOutputStream = new NonBlockingBitOutputStream(outputStream, ByteOrder.LITTLE_ENDIAN);
        LZWEncodeDictionary lZWEncodeDictionary = new LZWEncodeDictionary();
        lZWEncodeDictionary.reset();
        try {
            int n;
            nonBlockingBitOutputStream.writeBits(256, lZWEncodeDictionary.getCodeLength());
            byte[] byArray2 = ArrayHelper.EMPTY_BYTE_ARRAY;
            for (n = 0; n < byArray.length; ++n) {
                byte by = byArray[n];
                byArray2 = ArrayHelper.getConcatenated(byArray2, by);
                lZWEncodeDictionary.visit(by);
                int n2 = lZWEncodeDictionary.getCodeLength();
                LZWNode lZWNode = lZWEncodeDictionary.getNode(byArray2);
                if (n + 1 == byArray.length) {
                    nonBlockingBitOutputStream.writeBits(lZWNode.getTableIndex(), n2);
                    break;
                }
                if (lZWNode.getChildNode(byArray[n + 1]) == null) {
                    nonBlockingBitOutputStream.writeBits(lZWNode.getTableIndex(), n2);
                    byArray2 = ArrayHelper.EMPTY_BYTE_ARRAY;
                }
                if (lZWEncodeDictionary.getNextFreeCode() != 4095) continue;
                if (s_aLogger.isTraceEnabled()) {
                    s_aLogger.trace("Table overflow in encoding -> resetting (codelength=" + n2 + ";byteseq#=" + byArray2.length + ")");
                }
                nonBlockingBitOutputStream.writeBits(256, n2);
                lZWEncodeDictionary.reset();
                n -= byArray2.length;
                byArray2 = ArrayHelper.EMPTY_BYTE_ARRAY;
            }
            n = lZWEncodeDictionary.getCodeLength();
            switch (lZWEncodeDictionary.getNextFreeCode()) {
                case 511: 
                case 1023: 
                case 2047: {
                    ++n;
                    if (!s_aLogger.isDebugEnabled()) break;
                    s_aLogger.debug("EOF char gets a new code length: " + n);
                    break;
                }
            }
            nonBlockingBitOutputStream.writeBits(257, n);
        }
        catch (Throwable throwable) {
            throw new EncoderException("Error encoding LZW", throwable);
        }
        finally {
            StreamUtils.flush(nonBlockingBitOutputStream);
        }
    }

    protected static class LZWEncodeDictionary
    extends AbstractLZWDictionary {
        private final LZWNode m_aRoot = new LZWNode();
        private final NonBlockingByteArrayOutputStream m_aByteBuf = new NonBlockingByteArrayOutputStream();

        @Override
        public void reset() {
            super.reset();
            for (int i = 0; i < 256; ++i) {
                this.m_aRoot.setChildNode((byte)i, new LZWNode(i));
            }
            this.m_aByteBuf.reset();
        }

        public int getCodeLength() {
            return this.m_nCodeBits;
        }

        public boolean visit(byte by) {
            this.m_aByteBuf.write(by);
            LZWNode lZWNode = this.m_aRoot;
            for (byte by2 : this.m_aByteBuf.toByteArray()) {
                LZWNode lZWNode2 = lZWNode;
                if ((lZWNode = lZWNode.getChildNode(by2)) != null) continue;
                lZWNode2.setChildNode(by2, new LZWNode(this.m_nFreeCode));
                this.addEntry(this.m_aByteBuf.toByteArray(), true);
                this.m_aByteBuf.reset();
                this.m_aByteBuf.write(by);
                return true;
            }
            return false;
        }

        @Nullable
        public LZWNode getNode(@Nonnull byte[] byArray) {
            return this.m_aRoot.getChildNode(byArray);
        }
    }

    protected static class LZWDecodeDictionary
    extends AbstractLZWDictionary {
        public int readCode(@Nonnull NonBlockingBitInputStream nonBlockingBitInputStream) throws IOException {
            return nonBlockingBitInputStream.readBits(this.m_nCodeBits);
        }

        @Nullable
        public byte[] getBytes(@Nonnegative int n) {
            return this.m_aTab[n];
        }
    }

    protected static abstract class AbstractLZWDictionary {
        protected static final Logger s_aLogger = LoggerFactory.getLogger(AbstractLZWDictionary.class);
        public static final int MAX_CODE = 4096;
        public static final int CODE_CLEARTABLE = 256;
        public static final int CODE_EOF = 257;
        protected byte[][] m_aTab;
        protected int m_nFreeCode;
        protected int m_nCodeBits;

        public void reset() {
            this.m_aTab = new byte[4096][];
            for (int i = 0; i < 256; ++i) {
                this.m_aTab[i] = new byte[]{(byte)i};
            }
            this.m_nFreeCode = 258;
            this.m_nCodeBits = 9;
        }

        public final void addEntry(@Nonnull byte[] byArray, boolean bl) {
            ValueEnforcer.notNull(byArray, "ByteSeq");
            if (this.m_nFreeCode == this.m_aTab.length) {
                throw bl ? new EncoderException("LZW encode table overflow") : new DecoderException("LZW decode table overflow");
            }
            this.m_aTab[this.m_nFreeCode] = byArray;
            ++this.m_nFreeCode;
            if (this.m_nFreeCode == (bl ? 512 : 511)) {
                this.m_nCodeBits = 10;
            } else if (this.m_nFreeCode == (bl ? 1024 : 1023)) {
                this.m_nCodeBits = 11;
            } else if (this.m_nFreeCode == (bl ? 2048 : 2047)) {
                this.m_nCodeBits = 12;
            }
        }

        @Nonnegative
        public final int getNextFreeCode() {
            return this.m_nFreeCode;
        }
    }

    protected static class LZWNode {
        private final int m_nTableIndex;
        private LZWNode[] m_aChildren;

        public LZWNode() {
            this.m_nTableIndex = -1;
        }

        public LZWNode(@Nonnegative int n) {
            ValueEnforcer.isBetweenInclusive(n, "TableIndex", 0, 4096);
            this.m_nTableIndex = n;
        }

        @Nonnegative
        public int getTableIndex() {
            if (this.m_nTableIndex < 0) {
                throw new IllegalStateException("This node has no table index!");
            }
            return this.m_nTableIndex;
        }

        public void setChildNode(@Nonnegative byte by, @Nonnull LZWNode lZWNode) {
            ValueEnforcer.notNull(lZWNode, "Node");
            if (this.m_aChildren == null) {
                this.m_aChildren = new LZWNode[256];
            }
            this.m_aChildren[by & 0xFF] = lZWNode;
        }

        @Nullable
        public LZWNode getChildNode(byte by) {
            return this.m_aChildren == null ? null : this.m_aChildren[by & 0xFF];
        }

        @Nullable
        public LZWNode getChildNode(@Nonnull byte[] byArray) {
            byte by;
            LZWNode lZWNode = this;
            byte[] byArray2 = byArray;
            int n = byArray2.length;
            for (int i = 0; i < n && (lZWNode = lZWNode.getChildNode(by = byArray2[i])) != null; ++i) {
            }
            return lZWNode;
        }

        public String toString() {
            return new ToStringGenerator(null).append("index", this.m_nTableIndex).append("children#", ArrayHelper.getSize(this.m_aChildren)).toString();
        }
    }
}

