/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections;

import com.helger.commons.IHasSize;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.annotations.UseDirectEqualsAndHashCode;
import com.helger.commons.collections.LRUCache;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@UseDirectEqualsAndHashCode
@NotThreadSafe
public class LRUSet<ELEMENTTYPE>
extends AbstractSet<ELEMENTTYPE>
implements IHasSize,
Serializable {
    private final LRUCacheMap<ELEMENTTYPE> m_aCache;

    public LRUSet(@Nonnegative int n) {
        this.m_aCache = new LRUCacheMap(n, this);
    }

    @OverrideOnDemand
    protected void onRemoveEldestEntry(@Nonnull ELEMENTTYPE ELEMENTTYPE) {
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_aCache.getMaxSize();
    }

    @Override
    public boolean add(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (this.contains(ELEMENTTYPE)) {
            return false;
        }
        this.m_aCache.put(ELEMENTTYPE, Boolean.TRUE);
        return true;
    }

    @Override
    @Nonnull
    public Iterator<ELEMENTTYPE> iterator() {
        return this.m_aCache.keySet().iterator();
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aCache.size();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LRUSet)) {
            return false;
        }
        LRUSet lRUSet = (LRUSet)object;
        return this.m_aCache.equals(lRUSet.m_aCache);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aCache)).getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("cache", this.m_aCache).toString();
    }

    @UseDirectEqualsAndHashCode
    private static final class LRUCacheMap<ELEMENTTYPE>
    extends LRUCache<ELEMENTTYPE, Boolean> {
        private final LRUSet<ELEMENTTYPE> m_aOwningSet;

        LRUCacheMap(@Nonnegative int n, @Nonnull LRUSet<ELEMENTTYPE> lRUSet) {
            super(n);
            this.m_aOwningSet = lRUSet;
        }

        @Override
        protected void onRemoveEldestEntry(Map.Entry<ELEMENTTYPE, Boolean> entry) {
            this.m_aOwningSet.onRemoveEldestEntry(entry.getKey());
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

