/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections;

import com.helger.commons.IHasSize;
import com.helger.commons.annotations.ReturnsImmutableObject;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.collections.SingleMapEntry;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class SingleElementMap<KEYTYPE, VALUETYPE>
implements Map<KEYTYPE, VALUETYPE>,
IHasSize {
    private boolean m_bHasElement = false;
    private KEYTYPE m_aKey = null;
    private VALUETYPE m_aValue = null;

    public SingleElementMap() {
    }

    public SingleElementMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        this.put(KEYTYPE, VALUETYPE);
    }

    @Override
    public void clear() {
        this.m_bHasElement = false;
        this.m_aKey = null;
        this.m_aValue = null;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        return this.m_bHasElement && EqualsUtils.equals(this.m_aKey, object);
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        return this.m_bHasElement && EqualsUtils.equals(this.m_aValue, object);
    }

    @Override
    @Nullable
    public VALUETYPE get(@Nullable Object object) {
        return this.containsKey(object) ? (VALUETYPE)this.m_aValue : null;
    }

    @Override
    public boolean isEmpty() {
        return !this.m_bHasElement;
    }

    @Override
    @Nullable
    public VALUETYPE put(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        VALUETYPE VALUETYPE2 = null;
        if (EqualsUtils.equals(KEYTYPE, this.m_aKey)) {
            VALUETYPE2 = this.m_aValue;
        } else {
            this.m_aKey = KEYTYPE;
        }
        this.m_aValue = VALUETYPE;
        this.m_bHasElement = true;
        return VALUETYPE2;
    }

    @Override
    public void putAll(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (map != null && !map.isEmpty()) {
            if (map.size() != 1) {
                throw new IllegalArgumentException("Only maps with exactly one element are allowed!");
            }
            Map.Entry<KEYTYPE, VALUETYPE> entry = map.entrySet().iterator().next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Nullable
    public VALUETYPE remove(@Nullable Object object) {
        if (!this.containsKey(object)) {
            return null;
        }
        VALUETYPE VALUETYPE = this.m_aValue;
        this.m_bHasElement = false;
        this.m_aValue = null;
        this.m_aKey = null;
        return VALUETYPE;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_bHasElement ? 1 : 0;
    }

    @Override
    @Nonnull
    @ReturnsImmutableObject
    public Set<KEYTYPE> keySet() {
        return this.m_bHasElement ? ContainerHelper.newUnmodifiableSet(this.m_aKey) : Collections.emptySet();
    }

    @Override
    @Nonnull
    @ReturnsImmutableObject
    public Collection<VALUETYPE> values() {
        return this.m_bHasElement ? ContainerHelper.newUnmodifiableList(this.m_aValue) : Collections.emptyList();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<KEYTYPE, VALUETYPE>> entrySet() {
        HashSet<Map.Entry<KEYTYPE, VALUETYPE>> hashSet = new HashSet<Map.Entry<KEYTYPE, VALUETYPE>>(this.size());
        if (this.m_bHasElement) {
            hashSet.add(new SingleMapEntry<KEYTYPE, VALUETYPE>(this.m_aKey, this.m_aValue));
        }
        return hashSet;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SingleElementMap)) {
            return false;
        }
        SingleElementMap singleElementMap = (SingleElementMap)object;
        return this.m_bHasElement == singleElementMap.m_bHasElement && EqualsUtils.equals(this.m_aKey, singleElementMap.m_aKey) && EqualsUtils.equals(this.m_aValue, singleElementMap.m_aValue);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bHasElement).append(this.m_aKey).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("hasElement", this.m_bHasElement).append("key", this.m_aKey).append("value", this.m_aValue).toString();
    }
}

