/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.combine;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.combine.ICombinator;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CombinatorStringWithSeparatorIgnoreNull
implements ICombinator<String> {
    private final String m_sSep;

    public CombinatorStringWithSeparatorIgnoreNull(@Nonnull String string) {
        this.m_sSep = ValueEnforcer.notNull(string, "Separator");
    }

    @Nonnull
    public String getSeparator() {
        return this.m_sSep;
    }

    @Override
    @Nullable
    public String combine(@Nullable String string, @Nullable String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + this.m_sSep + string2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CombinatorStringWithSeparatorIgnoreNull)) {
            return false;
        }
        CombinatorStringWithSeparatorIgnoreNull combinatorStringWithSeparatorIgnoreNull = (CombinatorStringWithSeparatorIgnoreNull)object;
        return this.m_sSep.equals(combinatorStringWithSeparatorIgnoreNull.m_sSep);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sSep).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("sep", this.m_sSep).toString();
    }
}

